/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.serializer;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.utils.NBTUtils;

public class MarketSerializer {

    public static class MarketEntry {
        public static CompoundTag serializeMarketUserList(MarketUserEntryList entryList, int bits) {
            CompoundTag nbt = new CompoundTag();
            if ((bits & 0x10) != 0) {
                NBTUtils.putItemStack(nbt, "item", entryList.itemStack);
                if (entryList.tagID != null) {
                    nbt.m_128359_("tagID", entryList.tagID.toString());
                }
            }
            if ((bits & 0x11) != 0) {
                nbt.m_128365_("entries", (Tag)NBTUtils.serializeList(entryList.entries));
            }
            return nbt;
        }

        public static void deserializeMarketUserList(MarketUserEntryList entryList, CompoundTag nbt, int bits) {
            if ((bits & 0x10) != 0) {
                entryList.itemStack = NBTUtils.getItemStack(nbt, "item");
                if (nbt.m_128441_("tagID")) {
                    entryList.tagID = new ResourceLocation(nbt.m_128461_("tagID"));
                }
            }
            if ((bits & 0x11) != 0 && nbt.m_128441_("entries")) {
                ListTag d1 = (ListTag)nbt.m_128423_("entries");
                entryList.entries.clear();
                for (Tag tag : d1) {
                    MarketUserEntry userEntry = new MarketUserEntry();
                    userEntry.deserialize((CompoundTag)tag);
                    entryList.entries.add(userEntry);
                }
            }
        }

        public static CompoundTag serializeCategory(MarketUserCategory category, int bits) {
            CompoundTag nbt = new CompoundTag();
            if ((bits & 0x10) != 0) {
                nbt.m_128362_("categoryID", category.categoryID);
                NBTUtils.putItemStack(nbt, "icon", category.icon);
                nbt.m_128359_("categoryName", category.categoryName);
            }
            if ((bits & 0x11) != 0) {
                nbt.m_128365_("entries", (Tag)NBTUtils.serializeList(category.entries));
            }
            return nbt;
        }

        public static void deserializeCategory(MarketUserCategory category, CompoundTag nbt, int bits) {
            if ((bits & 0x10) != 0) {
                category.categoryID = nbt.m_128342_("categoryID");
                category.icon = NBTUtils.getItemStack(nbt, "icon");
                category.categoryName = nbt.m_128461_("categoryName");
            }
            if ((bits & 0x11) != 0 && nbt.m_128441_("entries")) {
                category.entries.clear();
                ListTag d1 = (ListTag)nbt.m_128423_("entries");
                for (Tag entryTag : d1) {
                    MarketUserEntryList entry = new MarketUserEntryList();
                    entry.deserialize((CompoundTag)entryTag);
                    category.entries.add(entry);
                }
            }
        }

        public static CompoundTag serializeCategoryWithoutEntries(MarketUserCategory category) {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("categoryID", category.categoryID);
            NBTUtils.putItemStack(nbt, "icon", category.icon);
            nbt.m_128359_("categoryName", category.categoryName);
            ListTag listTag = new ListTag();
            for (MarketUserEntryList serialize : category.entries) {
                listTag.add((Object)serialize.serialize(16));
            }
            nbt.m_128365_("entries", (Tag)listTag);
            return nbt;
        }

        public static void deserializeCategoryWithoutEntries(MarketUserCategory category, CompoundTag nbt) {
            category.categoryID = nbt.m_128342_("categoryID");
            category.icon = NBTUtils.getItemStack(nbt, "icon");
            category.categoryName = nbt.m_128461_("categoryName");
            if (nbt.m_128441_("entries")) {
                category.entries.clear();
                ListTag d1 = (ListTag)nbt.m_128423_("entries");
                for (Tag entryTag : d1) {
                    MarketUserEntryList entry = new MarketUserEntryList();
                    entry.deserialize((CompoundTag)entryTag, 16);
                    category.entries.add(entry);
                }
            }
        }

        public static List<Tag> serializeCategoryEntryListToList(MarketUserEntryList category) {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            for (MarketUserEntry entry : category.entries) {
                tags.add((Tag)entry.serialize());
            }
            return tags;
        }

        public static List<MarketUserEntry> deserializeCategoryEntryListToList(List<Tag> tags) {
            ArrayList<MarketUserEntry> list = new ArrayList<MarketUserEntry>();
            for (Tag tag : tags) {
                MarketUserEntry userEntry = new MarketUserEntry();
                userEntry.deserialize((CompoundTag)tag);
                list.add(userEntry);
            }
            return list;
        }
    }

    public static class MarketConfig {
    }
}

