/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.network.user;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.sixik.sdmmarket.api.MarketAPI;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.data.MarketUserManager;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.network.MarketNetwork;

public class BuyOfferC2S
extends BaseC2SMessage {
    public CompoundTag nbt;

    public BuyOfferC2S(CompoundTag nbt) {
        this.nbt = nbt;
    }

    public BuyOfferC2S(FriendlyByteBuf buf) {
        this.nbt = buf.m_130261_();
    }

    public MessageType getType() {
        return MarketNetwork.BUY_OFFER;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        MarketUserEntry entry = new MarketUserEntry();
        entry.deserialize(this.nbt);
        MarketUserCategory category = MarketUserManager.getCategoryByID(entry.categoryID);
        if (category == null) {
            return;
        }
        MarketUserEntryList entryList = MarketUserManager.getEntryListByCategory(category, entry.itemStack);
        if (entryList == null) {
            return;
        }
        Iterator iterator = entryList.entries.iterator();
        while (iterator.hasNext()) {
            MarketUserEntry userEntry = (MarketUserEntry)iterator.next();
            if (!Objects.equals(userEntry.entryID, entry.entryID) || !userEntry.buyEntry((ServerPlayer)context.getPlayer())) continue;
            iterator.remove();
            MarketAPI.syncMarket(context.getPlayer().m_20194_());
            MarketDataManager.saveMarketData(context.getPlayer().m_20194_());
            break;
        }
    }
}

