/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.network.admin;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmmarket.api.MarketAPI;
import net.sixik.sdmmarket.common.data.MarketConfigData;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.data.MarketUserManager;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.network.MarketNetwork;

public class EditCategoryC2S
extends BaseC2SMessage {
    private final UUID categoryID;
    private final CompoundTag nbt;

    public EditCategoryC2S(UUID categoryID, CompoundTag nbt) {
        this.categoryID = categoryID;
        this.nbt = nbt;
    }

    public EditCategoryC2S(FriendlyByteBuf buf) {
        this.categoryID = buf.m_130259_();
        this.nbt = buf.m_130261_();
    }

    public MessageType getType() {
        return MarketNetwork.EDIT_CATEGORY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.categoryID);
        buf.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getPlayer().m_20310_(2)) {
            MarketConfigCategory category = MarketDataManager.CONFIG_SERVER.getCategory(this.categoryID);
            if (category == null) {
                return;
            }
            if (this.nbt.m_128456_()) {
                MarketDataManager.CONFIG_SERVER.CATEGORIES.removeIf(s -> Objects.equals(s.categoryID, this.categoryID));
            } else {
                category.deserialize(this.nbt);
            }
            MarketConfigData.save(context.getPlayer().m_20194_());
            MarketUserManager.createOffersCategories(MarketDataManager.CONFIG_SERVER, MarketDataManager.USER_SERVER);
            MarketAPI.syncMarket(context.getPlayer().m_20194_());
        }
    }
}

