/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.network.admin;

import dev.architectury.networking.NetworkManager;
import dev.architectury.networking.simple.BaseC2SMessage;
import dev.architectury.networking.simple.MessageType;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.common.data.MarketConfigData;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.network.MarketNetwork;

public class CreateCategoryEntryC2S
extends BaseC2SMessage {
    private final UUID categoryID;
    private final CompoundTag nbt;

    public CreateCategoryEntryC2S(UUID categoryID, CompoundTag nbt) {
        this.categoryID = categoryID;
        this.nbt = nbt;
    }

    public CreateCategoryEntryC2S(FriendlyByteBuf buf) {
        this.categoryID = buf.m_130259_();
        this.nbt = buf.m_130261_();
    }

    public MessageType getType() {
        return MarketNetwork.CREATE_CATEGORY_ENTRY;
    }

    public void write(FriendlyByteBuf buf) {
        buf.m_130077_(this.categoryID);
        buf.m_130079_(this.nbt);
    }

    public void handle(NetworkManager.PacketContext context) {
        if (context.getPlayer().m_20310_(2)) {
            MarketConfigCategory category = MarketDataManager.CONFIG_SERVER.getCategory(this.categoryID);
            if (category == null) {
                return;
            }
            if (!this.nbt.m_128456_()) {
                AbstractMarketConfigEntry d1 = AbstractMarketConfigEntry.create(this.nbt);
                if (d1 == null) {
                    SDMMarket.LOGGER.error("Could not create entry: d1 == null");
                    return;
                }
                category.entries.add(d1);
            }
            MarketConfigData.save(context.getPlayer().m_20194_());
        }
    }
}

