/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.user;

import java.util.LinkedList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.serializer.MarketSerializer;
import net.sixik.sdmmarket.common.utils.INBTSerialize;

public class MarketUserEntryList
implements INBTSerialize {
    public ItemStack itemStack = ItemStack.f_41583_;
    public LinkedList<MarketUserEntry> entries = new LinkedList();
    public ResourceLocation tagID = null;

    public MarketUserEntryList sort(boolean less) {
        this.entries.sort((s, j) -> less ? Long.compare(s.price, j.price) : Long.compare(j.price, s.price));
        return this;
    }

    public MarketUserEntryList addElement(MarketUserEntry entry) {
        this.entries.add(entry);
        this.sort(true);
        return this;
    }

    public int getMinPrice() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        int i = -1;
        for (MarketUserEntry entry : this.entries) {
            if (i == -1) {
                i = (int)entry.price;
                continue;
            }
            i = (int)Math.min((long)i, entry.price);
        }
        return i;
    }

    public int getMaxPrice() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        int i = -1;
        for (MarketUserEntry entry : this.entries) {
            if (i == -1) {
                i = (int)entry.price;
                continue;
            }
            i = (int)Math.max((long)i, entry.price);
        }
        return i;
    }

    public int getMinCount() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        int i = -1;
        for (MarketUserEntry entry : this.entries) {
            if (i == -1) {
                i = entry.count;
                continue;
            }
            i = Math.min(i, entry.count);
        }
        return i;
    }

    public int getMaxCount() {
        if (this.entries.isEmpty()) {
            return -1;
        }
        int i = -1;
        for (MarketUserEntry entry : this.entries) {
            if (i == -1) {
                i = entry.count;
                continue;
            }
            i = Math.max(i, entry.count);
        }
        return i;
    }

    public boolean hasEnchantments() {
        if (this.itemStack.m_41792_()) {
            return false;
        }
        for (MarketUserEntry entry : this.entries) {
            if (!entry.itemStack.m_41793_()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        return this.serialize(17);
    }

    public CompoundTag serialize(int bits) {
        return MarketSerializer.MarketEntry.serializeMarketUserList(this, bits);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.deserialize(nbt, 17);
    }

    public void deserialize(CompoundTag nbt, int bits) {
        MarketSerializer.MarketEntry.deserializeMarketUserList(this, nbt, bits);
    }
}

