/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.user;

import java.util.Iterator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdm_economy.api.CurrencyHelper;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.api.MarketAPI;
import net.sixik.sdmmarket.client.SearchData;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.data.MarketPlayerData;
import net.sixik.sdmmarket.common.market.basketEntry.BasketItemEntry;
import net.sixik.sdmmarket.common.market.basketEntry.BasketMoneyEntry;
import net.sixik.sdmmarket.common.market.offer.OfferCreateData;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.network.user.SyncUserDataS2C;
import net.sixik.sdmmarket.common.network.user.UpdateUIS2C;
import net.sixik.sdmmarket.common.utils.INBTSerialize;
import net.sixik.sdmmarket.common.utils.NBTUtils;

public class MarketUserEntry
implements INBTSerialize {
    public UUID categoryID;
    public UUID entryID;
    public UUID ownerID;
    public boolean isSold = false;
    public ItemStack itemStack;
    public int count = 1;
    public long price = 0L;

    public MarketUserEntry() {
        this(UUID.randomUUID());
    }

    public MarketUserEntry(UUID categoryID) {
        this(ItemStack.f_41583_, categoryID);
    }

    public MarketUserEntry(ItemStack itemStack, UUID categoryID) {
        this.itemStack = itemStack;
        this.entryID = UUID.randomUUID();
        this.categoryID = categoryID;
    }

    public boolean isVisiable() {
        if (SearchData.isEncantable && !this.itemStack.m_41793_()) {
            return false;
        }
        if (SearchData.isNoDamaged && this.itemStack.m_41768_()) {
            return false;
        }
        return !(SearchData.priceFrom > 0L && this.price < SearchData.priceFrom || SearchData.priceTo > 0L && this.price > SearchData.priceTo || SearchData.countFrom > 0 && this.count < SearchData.countFrom || SearchData.countTo > 0 && this.count > SearchData.countTo);
    }

    public static MarketUserEntry fromOfferData(UUID categoryID, OfferCreateData createData) {
        MarketUserEntry entry = new MarketUserEntry(categoryID);
        entry.count = createData.count;
        entry.price = createData.price;
        entry.ownerID = createData.ownerID;
        entry.itemStack = createData.item;
        return entry;
    }

    public void closeEntry(ServerPlayer player) {
        try {
            MarketPlayerData.PlayerData data = MarketDataManager.getPlayerData((Player)player);
            if (data == null) {
                SDMMarket.LOGGER.error("Could not find MarketPlayerData for player " + player);
                return;
            }
            boolean removed = this.removeEntry();
            if (removed && data.playerOffers.removeIf(s -> Objects.equals(s, this.entryID))) {
                data.countOffers = Math.min(data.countOffers + 1, MarketDataManager.GLOBAL_CONFIG_SERVER.maxOffersForPlayer);
                BasketItemEntry itemEntry = new BasketItemEntry(this.itemStack, this.count);
                data.playerBasket.basketMoneyEntries.add(itemEntry);
                MarketAPI.syncMarket(player.f_8924_);
                new SyncUserDataS2C(data.serialize()).sendTo(player);
                MarketDataManager.savePlayer(player.f_8924_, (Player)player);
                MarketDataManager.saveMarketData(player.f_8924_);
            }
        }
        catch (Exception e) {
            SDMMarket.printStackTrace("", e);
        }
    }

    private boolean removeEntry() {
        for (MarketUserCategory category : MarketDataManager.USER_SERVER.categories) {
            for (MarketUserEntryList entry : category.entries) {
                Iterator iterator = entry.entries.iterator();
                while (iterator.hasNext()) {
                    MarketUserEntry userEntry = (MarketUserEntry)iterator.next();
                    if (!Objects.equals(userEntry.entryID, this.entryID)) continue;
                    iterator.remove();
                    SDMMarket.LOGGER.info("Removed entry " + userEntry.entryID);
                    return true;
                }
            }
        }
        SDMMarket.LOGGER.error("Couldn't remove entry: " + this.entryID);
        return false;
    }

    public boolean buyEntry(ServerPlayer player) {
        MarketPlayerData.PlayerData data = MarketDataManager.getPlayerData((Player)player);
        MarketPlayerData.PlayerData ownerData = MarketDataManager.getPlayerData(player.f_8924_, this.ownerID);
        if (CurrencyHelper.Basic.getMoney((Player)player) < this.price) {
            return false;
        }
        if (ownerData == null || data == null) {
            return false;
        }
        BasketMoneyEntry moneyEntry = new BasketMoneyEntry(this.price);
        ownerData.playerBasket.basketMoneyEntries.add(moneyEntry);
        ownerData.countOffers = Math.min(ownerData.countOffers + 1, MarketDataManager.GLOBAL_CONFIG_SERVER.maxOffersForPlayer);
        ownerData.playerOffers.removeIf(s -> Objects.equals(s, this.entryID));
        CurrencyHelper.Basic.addMoney((Player)player, (long)(-this.price));
        BasketItemEntry itemEntry = new BasketItemEntry(this.itemStack, this.count);
        data.playerBasket.basketMoneyEntries.add(itemEntry);
        MarketDataManager.savePlayer(player.f_8924_, data.playerID);
        MarketDataManager.savePlayer(player.f_8924_, ownerData.playerID);
        new UpdateUIS2C().sendTo(player);
        new SyncUserDataS2C(data.serialize()).sendTo(player);
        ServerPlayer ownerPlayer = player.f_8924_.m_6846_().m_11259_(this.ownerID);
        if (ownerPlayer != null) {
            new SyncUserDataS2C(ownerData.serialize()).sendTo(ownerPlayer);
        }
        return true;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("categoryID", this.categoryID);
        nbt.m_128362_("entryID", this.entryID);
        nbt.m_128362_("ownerID", this.ownerID);
        nbt.m_128379_("isSold", this.isSold);
        NBTUtils.putItemStack(nbt, "item", this.itemStack);
        nbt.m_128405_("count", this.count);
        nbt.m_128356_("price", this.price);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.categoryID = nbt.m_128342_("categoryID");
        this.entryID = nbt.m_128342_("entryID");
        this.ownerID = nbt.m_128342_("ownerID");
        this.isSold = nbt.m_128471_("isSold");
        this.itemStack = NBTUtils.getItemStack(nbt, "item");
        this.count = nbt.m_128451_("count");
        this.price = nbt.m_128454_("price");
    }
}

