/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.user;

import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.serializer.MarketSerializer;
import net.sixik.sdmmarket.common.utils.INBTSerialize;

public class MarketUserCategory
implements INBTSerialize {
    public UUID categoryID;
    public ItemStack icon = Items.f_42127_.m_7968_();
    public String categoryName;
    public CopyOnWriteArrayList<MarketUserEntryList> entries = new CopyOnWriteArrayList();

    public MarketUserCategory() {
        this(UUID.randomUUID(), "");
    }

    public MarketUserCategory(UUID categoryID, String name) {
        this.categoryID = categoryID;
        this.categoryName = name;
    }

    public MarketUserCategory setIcon(ItemStack icon) {
        this.icon = icon;
        return this;
    }

    public MarketUserCategory addEntry(MarketUserEntryList entry) {
        this.entries.add(entry);
        return this;
    }

    public void removeEntry(ItemStack item, UUID entryID) {
        for (MarketUserEntryList entry : this.entries) {
            if (!ItemStack.m_41728_((ItemStack)entry.itemStack, (ItemStack)item)) continue;
            entry.entries.removeIf(s -> Objects.equals(s.entryID, entryID));
            return;
        }
    }

    public boolean allEmpty() {
        if (this.entries.isEmpty()) {
            return true;
        }
        return this.entries.stream().allMatch(s -> s.entries.isEmpty());
    }

    @Override
    public CompoundTag serialize() {
        return this.serialize(17);
    }

    public CompoundTag serialize(int bits) {
        return MarketSerializer.MarketEntry.serializeCategory(this, bits);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.deserialize(nbt, 17);
    }

    public void deserialize(CompoundTag nbt, int bits) {
        MarketSerializer.MarketEntry.deserializeCategory(this, nbt, bits);
    }

    public CompoundTag serializeWithoutEntries() {
        return MarketSerializer.MarketEntry.serializeCategoryWithoutEntries(this);
    }

    public void deserializeWithoutEntries(CompoundTag nbt) {
        MarketSerializer.MarketEntry.deserializeCategoryWithoutEntries(this, nbt);
    }
}

