/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmmarket.common.ftb.ConfigIconItemStack;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.utils.INBTSerialize;
import net.sixik.sdmmarket.common.utils.NBTUtils;
import org.jetbrains.annotations.Nullable;

public class MarketConfigCategory
implements INBTSerialize {
    public UUID categoryID;
    public ItemStack icon = Items.f_42127_.m_7968_();
    public String categoryName;
    public List<AbstractMarketConfigEntry> entries = new ArrayList<AbstractMarketConfigEntry>();

    public MarketConfigCategory(String categoryName) {
        this.categoryName = categoryName;
        this.categoryID = UUID.randomUUID();
    }

    public MarketConfigCategory(UUID uuid, String categoryName) {
        this.categoryName = categoryName;
        this.categoryID = uuid;
    }

    @Nullable
    public AbstractMarketConfigEntry getEntry(UUID entryID) {
        for (AbstractMarketConfigEntry entry : this.entries) {
            if (!Objects.equals(entry.entryID, entryID)) continue;
            return entry;
        }
        return null;
    }

    public MarketConfigCategory setIcon(ItemStack icon) {
        this.icon = icon;
        return this;
    }

    public void config(ConfigGroup group) {
        group.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.icon, v -> {
            this.icon = v;
        }, (Object)Items.f_42127_.m_7968_());
        group.addString("categoryName", this.categoryName, v -> {
            this.categoryName = v;
        }, "Empty Name");
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("categoryID", this.categoryID);
        NBTUtils.putItemStack(nbt, "icon", this.icon);
        nbt.m_128359_("categoryName", this.categoryName);
        ListTag d1 = new ListTag();
        for (AbstractMarketConfigEntry entry : this.entries) {
            d1.add((Object)entry.serialize());
        }
        nbt.m_128365_("entries", (Tag)d1);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        this.categoryID = nbt.m_128342_("categoryID");
        this.icon = NBTUtils.getItemStack(nbt, "icon");
        this.categoryName = nbt.m_128461_("categoryName");
        if (nbt.m_128441_("entries")) {
            ListTag d1 = (ListTag)nbt.m_128423_("entries");
            for (Tag entryTag : d1) {
                AbstractMarketConfigEntry entry = AbstractMarketConfigEntry.create((CompoundTag)entryTag);
                if (entry == null) continue;
                this.entries.add(entry);
            }
        }
    }
}

