/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.config;

import com.mojang.datafixers.util.Pair;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.NameMap;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;

public class ItemTagMarketConfigEntry
extends AbstractMarketConfigEntry {
    public static ResourceLocation DEFAULT = new ResourceLocation("minecraft", "anvil");
    public ResourceLocation tagKey = DEFAULT;

    public ItemTagMarketConfigEntry(UUID categoryID) {
        super(categoryID);
    }

    @Override
    public void config(ConfigGroup group) {
        group.addEnum("tags", (Object)this.tagKey.toString(), v -> {
            this.tagKey = new ResourceLocation(v);
        }, this.getTags());
    }

    @Override
    public boolean isAvailable(ItemStack itemStack) {
        Optional<TagKey> op = BuiltInRegistries.f_257033_.m_203612_().filter(s -> ((TagKey)s.getFirst()).f_203868_().equals((Object)this.tagKey)).findFirst().map(Pair::getFirst);
        return op.filter(arg_0 -> ((ItemStack)itemStack).m_204117_(arg_0)).isPresent();
    }

    public Optional<HolderSet.Named<Item>> getItems() {
        return BuiltInRegistries.f_257033_.m_203612_().filter(s -> ((TagKey)s.getFirst()).f_203868_().equals((Object)this.tagKey)).findFirst().map(Pair::getSecond);
    }

    public NameMap<String> getTags() {
        ArrayList str = new ArrayList();
        BuiltInRegistries.f_257033_.m_203612_().forEach(s -> str.add(((TagKey)s.getFirst()).f_203868_().toString()));
        return NameMap.of((Object)DEFAULT.toString(), str).create();
    }

    @Override
    public Icon getIcon() {
        Optional<Pair> optional = BuiltInRegistries.f_257033_.m_203612_().filter(s -> ((TagKey)s.getFirst()).f_203868_().equals((Object)this.tagKey)).findFirst();
        if (optional.isEmpty()) {
            return ItemIcon.getItemIcon((Item)Items.f_42656_);
        }
        HolderSet.Named itemHolder = (HolderSet.Named)optional.get().getSecond();
        return ItemIcon.getItemIcon((Item)((Item)itemHolder.m_203662_(0).m_203334_()));
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        nbt.m_128359_("typeID", "itemTagType");
        nbt.m_128359_("tagKey", this.tagKey.toString());
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.tagKey = new ResourceLocation(nbt.m_128461_("tagKey"));
    }
}

