/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.register.CustomIconItem;
import net.sixik.sdmmarket.common.register.ItemsRegister;
import net.sixik.sdmmarket.common.utils.MarketItemHelper;
import net.sixik.sdmmarket.common.utils.NBTUtils;

public class ItemMarketConfigEntry
extends AbstractMarketConfigEntry {
    public ItemStack itemStack;

    public ItemMarketConfigEntry(UUID categoryID, ItemStack item) {
        super(categoryID);
        this.itemStack = item;
    }

    @Override
    public Icon getIcon() {
        if (this.itemStack.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.itemStack);
        }
        return ItemIcon.getItemIcon((ItemStack)this.itemStack);
    }

    @Override
    public boolean isAvailable(ItemStack itemStack1) {
        return MarketItemHelper.isEquals(itemStack1.m_41777_(), this.itemStack.m_41777_());
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        NBTUtils.putItemStack(nbt, "item", this.itemStack);
        nbt.m_128359_("typeID", "itemType");
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.itemStack = NBTUtils.getItemStack(nbt, "item");
    }

    @Override
    public void config(ConfigGroup group) {
        group.addItemStack("item", this.itemStack, v -> {
            this.itemStack = v;
        }, ItemStack.f_41583_, 1);
        super.config(group);
    }
}

