/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.register.CustomIconItem;
import net.sixik.sdmmarket.common.register.ItemsRegister;
import net.sixik.sdmmarket.common.utils.MarketItemHelper;
import net.sixik.sdmmarket.common.utils.NBTUtils;

public class DurabilityMarketConfigEntry
extends AbstractMarketConfigEntry {
    public ItemStack itemStack;
    public boolean enchantable = false;
    public boolean damagebled = false;

    public DurabilityMarketConfigEntry(UUID categoryID, ItemStack itemStack) {
        super(categoryID);
        this.itemStack = itemStack;
    }

    public DurabilityMarketConfigEntry setDamagebled(boolean damagebled) {
        this.damagebled = damagebled;
        return this;
    }

    public DurabilityMarketConfigEntry setEnchantable(boolean enchantable) {
        this.enchantable = enchantable;
        return this;
    }

    @Override
    public boolean isAvailable(ItemStack itemStack1) {
        ItemStack d1 = itemStack1.m_41777_();
        d1.m_41764_(1);
        if (!this.damagebled && d1.m_41773_() > 0) {
            return false;
        }
        if (!this.enchantable && d1.m_41793_()) {
            return false;
        }
        return MarketItemHelper.isEquals(d1, this.itemStack);
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = super.serialize();
        NBTUtils.putItemStack(nbt, "item", this.itemStack);
        nbt.m_128359_("typeID", "durabilityType");
        nbt.m_128379_("enchantable", this.enchantable);
        nbt.m_128379_("damagebled", this.damagebled);
        return nbt;
    }

    @Override
    public Icon getIcon() {
        if (this.itemStack.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.itemStack);
        }
        return ItemIcon.getItemIcon((ItemStack)this.itemStack);
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        super.deserialize(nbt);
        this.itemStack = NBTUtils.getItemStack(nbt, "item");
        this.enchantable = nbt.m_128471_("enchantable");
        this.damagebled = nbt.m_128471_("damagebled");
    }

    @Override
    public void config(ConfigGroup group) {
        group.addItemStack("item", this.itemStack, v -> {
            this.itemStack = v;
        }, ItemStack.f_41583_, 1);
        group.addBool("enchantable", this.enchantable, v -> {
            this.enchantable = v;
        }, false);
        group.addBool("damagebled", this.damagebled, v -> {
            this.damagebled = v;
        }, false);
        super.config(group);
    }
}

