/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.market.config;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.market.config.DurabilityMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemTagMarketConfigEntry;
import net.sixik.sdmmarket.common.utils.INBTSerialize;

public abstract class AbstractMarketConfigEntry
implements INBTSerialize {
    public UUID categoryID;
    public UUID entryID;
    public long minPrice = 0L;
    public long maxPrice = 0L;

    public AbstractMarketConfigEntry(UUID categoryID) {
        this.categoryID = categoryID;
        this.entryID = UUID.randomUUID();
    }

    public static AbstractMarketConfigEntry create(CompoundTag nbt) {
        String id = nbt.m_128461_("typeID");
        if (Objects.equals(id, "durabilityType")) {
            DurabilityMarketConfigEntry marketConfigEntry = new DurabilityMarketConfigEntry(null, ItemStack.f_41583_);
            marketConfigEntry.deserialize(nbt);
            return marketConfigEntry;
        }
        if (Objects.equals(id, "itemType")) {
            ItemMarketConfigEntry marketConfigEntry = new ItemMarketConfigEntry(null, ItemStack.f_41583_);
            marketConfigEntry.deserialize(nbt);
            return marketConfigEntry;
        }
        if (Objects.equals(id, "itemTagType")) {
            ItemTagMarketConfigEntry marketConfigEntry = new ItemTagMarketConfigEntry(null);
            marketConfigEntry.deserialize(nbt);
            return marketConfigEntry;
        }
        return null;
    }

    public boolean isAvailable(ItemStack itemStack) {
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128362_("categoryID", this.categoryID);
        nbt.m_128362_("entryID", this.entryID);
        nbt.m_128356_("minPrice", this.minPrice);
        nbt.m_128356_("maxPrice", this.maxPrice);
        return nbt;
    }

    public abstract Icon getIcon();

    @Override
    public void deserialize(CompoundTag nbt) {
        this.categoryID = nbt.m_128342_("categoryID");
        this.entryID = nbt.m_128342_("entryID");
        this.minPrice = nbt.m_128454_("minPrice");
        this.maxPrice = nbt.m_128454_("maxPrice");
    }

    public void config(ConfigGroup group) {
        group.addLong("minPrice", this.minPrice, v -> {
            this.minPrice = v;
        }, 0L, 0L, Integer.MAX_VALUE);
        group.addLong("maxPrice", this.maxPrice, v -> {
            this.maxPrice = v;
        }, 0L, 0L, Integer.MAX_VALUE);
    }
}

