/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.data.MarketConfigData;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.data.MarketPlayerData;
import net.sixik.sdmmarket.common.data.MarketUserData;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemTagMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.market.offer.OfferCreateData;
import net.sixik.sdmmarket.common.market.user.MarketUserAnyCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.network.user.SyncUserDataS2C;
import net.sixik.sdmmarket.common.utils.MarketItemHelper;
import org.jetbrains.annotations.Nullable;

public class MarketUserManager {
    @Nullable
    public static MarketUserCategory getCategoryByID(UUID categoryID) {
        for (MarketUserCategory category : MarketDataManager.USER_SERVER.categories) {
            if (!Objects.equals(category.categoryID, categoryID)) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public static MarketUserEntry getEntryByID(UUID entryID) {
        for (MarketUserCategory category : MarketDataManager.USER_SERVER.categories) {
            for (MarketUserEntryList entryList : category.entries) {
                for (MarketUserEntry entry : entryList.entries) {
                    if (!Objects.equals(entry.entryID, entryID)) continue;
                    return entry;
                }
            }
        }
        return null;
    }

    @Nullable
    public static MarketUserEntryList getEntryListByID(UUID categoryID, ItemStack itemStack) {
        for (MarketUserCategory category : MarketDataManager.USER_SERVER.categories) {
            if (!Objects.equals(category.categoryID, categoryID)) continue;
            for (MarketUserEntryList entry : category.entries) {
                if (entry.itemStack.m_41782_() && ItemStack.m_150942_((ItemStack)itemStack, (ItemStack)entry.itemStack)) {
                    return entry;
                }
                if (entry.itemStack.m_41782_() || !ItemStack.m_41656_((ItemStack)itemStack, (ItemStack)entry.itemStack)) continue;
                return entry;
            }
        }
        return null;
    }

    @Nullable
    public static MarketUserEntryList getEntryListByCategory(MarketUserCategory category, ItemStack itemStack) {
        ItemStack j = itemStack.m_41777_();
        j.m_41721_(0);
        for (MarketUserEntryList entry : category.entries) {
            if (!MarketItemHelper.isEquals(j, entry.itemStack)) continue;
            return entry;
        }
        if (MarketDataManager.GLOBAL_CONFIG_SERVER != null && MarketDataManager.GLOBAL_CONFIG_SERVER.sellAnyItems && Objects.equals(category.categoryID.toString(), "619a4773-efd4-46e5-97c5-5ce1ce2da517")) {
            MarketUserEntryList entryList = new MarketUserEntryList();
            entryList.itemStack = j;
            category.addEntry(entryList);
            for (MarketUserEntryList entry : category.entries) {
                if (!MarketItemHelper.isEquals(j, entry.itemStack)) continue;
                return entry;
            }
        }
        return null;
    }

    public static boolean syncUserData(ServerPlayer player) {
        for (MarketPlayerData.PlayerData data : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            if (!data.playerID.equals(player.m_36316_().getId())) continue;
            new SyncUserDataS2C(data.serialize()).sendTo(player);
            return true;
        }
        return false;
    }

    public static boolean canCreateOfferWithItem(ItemStack itemStack, MarketConfigData configData) {
        for (MarketConfigCategory category : configData.CATEGORIES) {
            for (AbstractMarketConfigEntry entry : category.entries) {
                if (!entry.isAvailable(itemStack)) continue;
                return true;
            }
        }
        return MarketDataManager.GLOBAL_CONFIG_SERVER != null && MarketDataManager.GLOBAL_CONFIG_SERVER.sellAnyItems || MarketDataManager.GLOBAL_CONFIG_CLIENT != null && MarketDataManager.GLOBAL_CONFIG_CLIENT.sellAnyItems;
    }

    public static MarketConfigCategory getCategoryForItem(ItemStack itemStack, MarketConfigData configData) {
        for (MarketConfigCategory category : configData.CATEGORIES) {
            for (AbstractMarketConfigEntry entry : category.entries) {
                if (!entry.isAvailable(itemStack)) continue;
                return category;
            }
        }
        if (MarketDataManager.GLOBAL_CONFIG_SERVER != null && MarketDataManager.GLOBAL_CONFIG_SERVER.sellAnyItems || MarketDataManager.GLOBAL_CONFIG_CLIENT != null && MarketDataManager.GLOBAL_CONFIG_CLIENT.sellAnyItems) {
            MarketUserAnyCategory _category = new MarketUserAnyCategory();
            return new MarketConfigCategory(_category.categoryID, _category.categoryName);
        }
        return null;
    }

    public static AbstractMarketConfigEntry getEntryForItem(ItemStack itemStack, MarketConfigData configData, MarketConfigCategory category) {
        for (AbstractMarketConfigEntry entry : category.entries) {
            if (!entry.isAvailable(itemStack)) continue;
            return entry;
        }
        if (MarketDataManager.GLOBAL_CONFIG_SERVER != null && MarketDataManager.GLOBAL_CONFIG_SERVER.sellAnyItems || MarketDataManager.GLOBAL_CONFIG_CLIENT != null && MarketDataManager.GLOBAL_CONFIG_CLIENT.sellAnyItems) {
            MarketUserAnyCategory _category = new MarketUserAnyCategory();
            return new ItemMarketConfigEntry(_category.categoryID, itemStack);
        }
        return null;
    }

    public static AbstractMarketConfigEntry getEntryForItem(ItemStack itemStack, MarketConfigData configData) {
        for (MarketConfigCategory category : configData.CATEGORIES) {
            for (AbstractMarketConfigEntry entry : category.entries) {
                if (!entry.isAvailable(itemStack)) continue;
                return entry;
            }
        }
        return null;
    }

    public static void createOfferWithItem(OfferCreateData offerData, MarketConfigData configData, MarketUserData userData) {
        MarketConfigCategory configCategory = MarketUserManager.getCategoryForItem(offerData.item, configData);
        if (configCategory == null) {
            return;
        }
        MarketUserCategory marketUserCategory = null;
        for (MarketUserCategory marketUserCategory2 : userData.categories) {
            if (!Objects.equals(marketUserCategory2.categoryID, configCategory.categoryID)) continue;
            marketUserCategory = marketUserCategory2;
            break;
        }
        if (marketUserCategory == null) {
            return;
        }
        MarketUserEntryList entryList = null;
        for (MarketUserEntryList entry : marketUserCategory.entries) {
            if (!ItemStack.m_41656_((ItemStack)offerData.item, (ItemStack)entry.itemStack)) continue;
            entryList = entry;
            break;
        }
        if (entryList == null) {
            return;
        }
        MarketUserEntry marketUserEntry = MarketUserEntry.fromOfferData(marketUserCategory.categoryID, offerData);
        entryList.addElement(marketUserEntry);
    }

    public static void createOffersCategories(MarketConfigData data, MarketUserData toUserData) {
        MarketUserData userData = new MarketUserData();
        for (MarketConfigCategory category : data.CATEGORIES) {
            MarketUserCategory userCategory = new MarketUserCategory();
            userCategory.categoryID = category.categoryID;
            userCategory.categoryName = category.categoryName;
            userCategory.icon = category.icon;
            for (AbstractMarketConfigEntry entry : category.entries) {
                if (entry instanceof ItemTagMarketConfigEntry) {
                    ItemTagMarketConfigEntry tagConfig = (ItemTagMarketConfigEntry)entry;
                    Optional<HolderSet.Named<Item>> t = tagConfig.getItems();
                    if (t.isEmpty()) continue;
                    HolderSet.Named<Item> ent = t.get();
                    for (Holder itemHolder : ent) {
                        MarketUserEntryList userEntryList = new MarketUserEntryList();
                        userEntryList.tagID = tagConfig.tagKey;
                        userEntryList.itemStack = ((Item)itemHolder.m_203334_()).m_7968_();
                        userCategory.entries.add(userEntryList);
                    }
                    continue;
                }
                MarketUserEntryList userEntryList = new MarketUserEntryList();
                Icon icon = entry.getIcon();
                if (icon instanceof ItemIcon) {
                    ItemIcon icon2 = (ItemIcon)icon;
                    userEntryList.itemStack = icon2.getStack();
                }
                userCategory.entries.add(userEntryList);
            }
            userData.categories.add(userCategory);
        }
        MarketUserAnyCategory anyCategory = new MarketUserAnyCategory();
        userData.categories.add(anyCategory);
        toUserData.copyFrom(userData);
    }

    public static List<ItemStack> getAvaliableItems(Player player, MarketConfigData configData) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        Inventory inventory = player.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_() || !MarketUserManager.canCreateOfferWithItem(itemStack, configData) || MarketUserManager.isContains(items, itemStack)) continue;
            items.add(itemStack);
        }
        return items;
    }

    public static boolean isContains(List<ItemStack> list, ItemStack itemStack) {
        for (ItemStack stack : list) {
            if (!MarketItemHelper.isEquals(itemStack.m_41777_(), stack.m_41777_())) continue;
            return true;
        }
        return false;
    }
}

