/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.utils.INBTSerialize;
import net.sixik.sdmmarket.common.utils.NBTUtils;

public class MarketUserData
implements INBTSerialize {
    public List<MarketUserCategory> categories = new ArrayList<MarketUserCategory>();

    public void copyFromOverwrite(MarketUserData other) {
        this.categories.clear();
        this.categories.addAll(other.categories);
    }

    public void copyFrom(MarketUserData other) {
        if (this.categories.isEmpty()) {
            this.categories.addAll(other.categories);
            return;
        }
        Iterator<MarketUserCategory> iterator = this.categories.iterator();
        while (iterator.hasNext()) {
            MarketUserCategory category = iterator.next();
            boolean found = false;
            for (MarketUserCategory otherCategory : other.categories) {
                if (!category.categoryID.equals(otherCategory.categoryID)) continue;
                found = true;
                category.categoryName = otherCategory.categoryName;
                if (category.entries.isEmpty()) {
                    category.entries.addAll(otherCategory.entries);
                    break;
                }
                for (MarketUserEntryList otherEntry : otherCategory.entries) {
                    boolean entryExists = false;
                    for (MarketUserEntryList currentEntry : category.entries) {
                        if (!ItemStack.m_41656_((ItemStack)otherEntry.itemStack, (ItemStack)currentEntry.itemStack)) continue;
                        entryExists = true;
                        break;
                    }
                    if (entryExists) continue;
                    category.entries.add(otherEntry);
                }
            }
            if (found || !category.allEmpty()) continue;
            System.out.println(category.categoryName);
            iterator.remove();
        }
        for (MarketUserCategory otherCategory : other.categories) {
            boolean found = false;
            for (MarketUserCategory currentCategory : this.categories) {
                if (!otherCategory.categoryID.equals(currentCategory.categoryID)) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.categories.add(otherCategory);
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        ListTag list = NBTUtils.serializeList(this.categories);
        nbt.m_128365_("categories", (Tag)list);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128441_("categories")) {
            ListTag d1 = (ListTag)nbt.m_128423_("categories");
            this.categories.clear();
            for (Tag entryTag : d1) {
                MarketUserCategory category = new MarketUserCategory();
                category.deserialize((CompoundTag)entryTag);
                this.categories.add(category);
            }
        }
    }
}

