/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.basketEntry.AbstractBasketEntry;
import net.sixik.sdmmarket.common.market.user.MarketUserCategory;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.market.user.MarketUserEntryList;
import net.sixik.sdmmarket.common.utils.INBTSerialize;

public class MarketPlayerData {
    public List<PlayerData> PLAYERS = new ArrayList<PlayerData>();

    public static class PlayerBasket
    implements INBTSerialize {
        public List<AbstractBasketEntry> basketMoneyEntries = new ArrayList<AbstractBasketEntry>();

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            ListTag list = new ListTag();
            for (AbstractBasketEntry basketMoneyEntry : this.basketMoneyEntries) {
                list.add((Object)basketMoneyEntry.serialize());
            }
            nbt.m_128365_("basketMoneyEntries", (Tag)list);
            return nbt;
        }

        @Override
        public void deserialize(CompoundTag nbt) {
            if (nbt.m_128441_("basketMoneyEntries")) {
                ListTag d1 = (ListTag)nbt.m_128423_("basketMoneyEntries");
                this.basketMoneyEntries.clear();
                for (Tag tag : d1) {
                    AbstractBasketEntry f = AbstractBasketEntry.from((CompoundTag)tag);
                    if (f == null) continue;
                    this.basketMoneyEntries.add(f);
                }
            }
        }
    }

    public static class PlayerData
    implements INBTSerialize {
        public UUID playerID;
        public int countOffers = 0;
        public long numberOfOperations = 0L;
        public long countMoneyByOperations = 0L;
        public List<UUID> playerOffers = new ArrayList<UUID>();
        public PlayerBasket playerBasket = new PlayerBasket();

        public PlayerData() {
            if (MarketDataManager.GLOBAL_CONFIG_SERVER != null) {
                this.countOffers = MarketDataManager.GLOBAL_CONFIG_SERVER.maxOffersForPlayer;
            }
        }

        public void updateOffersCount() {
            this.countOffers = MarketDataManager.GLOBAL_CONFIG_SERVER.maxOffersForPlayer - this.playerOffers.size();
        }

        public List<MarketUserEntry> findClientOffers() {
            if (this.playerOffers.isEmpty()) {
                return new ArrayList<MarketUserEntry>();
            }
            ArrayList<MarketUserEntry> list = new ArrayList<MarketUserEntry>();
            for (MarketUserCategory category : MarketDataManager.USER_CLIENT.categories) {
                for (MarketUserEntryList entry : category.entries) {
                    for (MarketUserEntry userEntry : entry.entries) {
                        if (!Objects.equals(userEntry.ownerID, this.playerID)) continue;
                        list.add(userEntry);
                    }
                }
            }
            return list;
        }

        @Override
        public CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128362_("playerID", this.playerID);
            nbt.m_128405_("countOffers", this.countOffers);
            nbt.m_128356_("numberOfOperations", this.numberOfOperations);
            nbt.m_128356_("countMoneyByOperations", this.countMoneyByOperations);
            nbt.m_128365_("playerBasket", (Tag)this.playerBasket.serialize());
            ListTag d1 = new ListTag();
            for (UUID playerOffer : this.playerOffers) {
                d1.add((Object)NbtUtils.m_129226_((UUID)playerOffer));
            }
            nbt.m_128365_("offers", (Tag)d1);
            return nbt;
        }

        @Override
        public void deserialize(CompoundTag nbt) {
            this.playerID = nbt.m_128342_("playerID");
            this.countOffers = nbt.m_128451_("countOffers");
            this.numberOfOperations = nbt.m_128454_("numberOfOperations");
            this.countMoneyByOperations = nbt.m_128454_("countMoneyByOperations");
            this.playerBasket.deserialize(nbt.m_128469_("playerBasket"));
            this.playerOffers.clear();
            if (nbt.m_128441_("offers")) {
                ListTag d1 = (ListTag)nbt.m_128423_("offers");
                for (Tag tag : d1) {
                    this.playerOffers.add(NbtUtils.m_129233_((Tag)tag));
                }
            }
        }
    }
}

