/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.common.utils.INBTSerialize;
import org.jetbrains.annotations.Nullable;

public class MarketFileManager {
    private static final String[] paths = new String[]{"SDMMarket", "SDMMarket/config", "SDMMarket/offers", "SDMMarket/players"};

    public static void init(MinecraftServer server) {
        MarketFileManager.createFolders(server);
    }

    public static void createFolders(MinecraftServer server) {
        for (String path : paths) {
            Path f1 = server.m_129843_(LevelResource.f_78182_).resolve(path);
            if (f1.toFile().exists()) continue;
            f1.toFile().mkdir();
        }
    }

    public static void saveData(MinecraftServer server, String path, INBTSerialize serialize) {
        Path f1 = server.m_129843_(LevelResource.f_78182_).resolve(path);
        try {
            NbtIo.m_128955_((CompoundTag)serialize.serialize(), (File)f1.toFile());
        }
        catch (IOException e) {
            SDMMarket.printStackTrace("", e);
        }
    }

    public static void saveDataReadable(MinecraftServer server, String path, INBTSerialize serialize) {
        Path f1 = server.m_129843_(LevelResource.f_78182_).resolve(path);
        try {
            SNBT.write((Path)f1, (CompoundTag)serialize.serialize());
        }
        catch (Exception e) {
            SDMMarket.printStackTrace("", e);
        }
    }

    @Nullable
    public static CompoundTag readData(MinecraftServer server, String path) {
        Path f1 = server.m_129843_(LevelResource.f_78182_).resolve(path);
        if (!f1.toFile().exists()) {
            return null;
        }
        try {
            return NbtIo.m_128953_((File)f1.toFile());
        }
        catch (Exception e) {
            SDMMarket.printStackTrace("", e);
            return null;
        }
    }

    @Nullable
    public static SNBTCompoundTag readDataReadable(MinecraftServer server, String path) {
        Path f1 = server.m_129843_(LevelResource.f_78182_).resolve(path);
        if (!f1.toFile().exists()) {
            return null;
        }
        try {
            return SNBT.read((Path)f1);
        }
        catch (Exception e) {
            SDMMarket.printStackTrace("", e);
            return null;
        }
    }
}

