/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.common.data.MarketConfig;
import net.sixik.sdmmarket.common.data.MarketConfigData;
import net.sixik.sdmmarket.common.data.MarketPlayerData;
import net.sixik.sdmmarket.common.data.MarketUserData;
import net.sixik.sdmmarket.common.network.user.SyncUserDataS2C;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class MarketDataManager {
    public static MarketConfigData CONFIG_CLIENT = new MarketConfigData();
    public static MarketConfigData CONFIG_SERVER;
    public static MarketUserData USER_CLIENT;
    public static MarketUserData USER_SERVER;
    public static MarketConfig GLOBAL_CONFIG_SERVER;
    public static MarketConfig GLOBAL_CONFIG_CLIENT;
    public static MarketPlayerData PLAYERS_SERVER_DATA;
    public static MarketPlayerData.PlayerData PLAYER_CLIENT_DATA;

    @Nullable
    public static MarketPlayerData.PlayerData getPlayerData(Player player) {
        Optional<MarketPlayerData.PlayerData> data = MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.stream().filter(s -> Objects.equals(s.playerID, player.m_36316_().getId())).findFirst();
        if (data.isEmpty()) {
            MarketPlayerData.PlayerData f = new MarketPlayerData.PlayerData();
            f.playerID = player.m_36316_().getId();
            MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.add(f);
            data = MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.stream().filter(s -> Objects.equals(s.playerID, player.m_36316_().getId())).findFirst();
        }
        return data.orElse(null);
    }

    public static void updatePlayersData(MinecraftServer server) {
        if (server == null) {
            return;
        }
        for (MarketPlayerData.PlayerData player : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            player.updateOffersCount();
        }
        for (MarketPlayerData.PlayerData player : server.m_6846_().m_11314_()) {
            MarketPlayerData.PlayerData ownerData = MarketDataManager.getPlayerData(server, (Player)player);
            if (ownerData == null) continue;
            new SyncUserDataS2C(ownerData.serialize()).sendTo((ServerPlayer)player);
        }
    }

    public static MarketPlayerData.PlayerData getPlayerData(MinecraftServer server, Player player) {
        return MarketDataManager.getPlayerData(server, player.m_36316_().getId());
    }

    @Nullable
    public static MarketPlayerData.PlayerData getPlayerData(MinecraftServer server, UUID uuid) {
        for (MarketPlayerData.PlayerData player : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            if (!Objects.equals(player.playerID, uuid)) continue;
            return player;
        }
        MarketDataManager.loadPlayer(server, uuid);
        for (MarketPlayerData.PlayerData player : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            if (!Objects.equals(player.playerID, uuid)) continue;
            return player;
        }
        return null;
    }

    public static void savePlayers(MinecraftServer server) {
        for (MarketPlayerData.PlayerData player : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            MarketDataManager.savePlayer(server, player);
        }
    }

    public static boolean savePlayer(MinecraftServer server, Player player) {
        return MarketDataManager.savePlayer(server, player.m_36316_().getId());
    }

    public static boolean savePlayer(MinecraftServer server, UUID player) {
        MarketPlayerData.PlayerData data = null;
        for (MarketPlayerData.PlayerData playerData : MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS) {
            if (!Objects.equals(playerData.playerID, player)) continue;
            data = playerData;
            break;
        }
        if (data == null) {
            return false;
        }
        return MarketDataManager.savePlayer(server, data);
    }

    public static boolean savePlayer(MinecraftServer server, MarketPlayerData.PlayerData data) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("SDMMarket/players/" + data.playerID.toString() + ".sdm");
        SNBT.write((Path)path, (CompoundTag)data.serialize());
        return true;
    }

    public static boolean saveAndRemove(MinecraftServer server, UUID player) {
        if (MarketDataManager.savePlayer(server, player)) {
            return MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.removeIf(data -> Objects.equals(data.playerID, player));
        }
        return false;
    }

    public static void loadPlayers(MinecraftServer server) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("SDMMarket/players");
        if (!path.toFile().exists()) {
            return;
        }
        MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.clear();
        for (File file : path.toFile().listFiles()) {
            try {
                SNBTCompoundTag nbt = SNBT.read((Path)file.toPath());
                if (nbt == null) continue;
                MarketPlayerData.PlayerData data = new MarketPlayerData.PlayerData();
                data.deserialize((CompoundTag)nbt);
                MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.add(data);
            }
            catch (Exception e) {
                SDMMarket.printStackTrace("", e);
            }
        }
    }

    public static void loadPlayer(MinecraftServer server, Player player) {
        MarketDataManager.loadPlayer(server, player.m_36316_().getId());
    }

    public static void loadPlayer(MinecraftServer server, UUID player) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("SDMMarket/players/" + player.toString() + ".sdm");
        if (!path.toFile().exists()) {
            MarketPlayerData.PlayerData d = new MarketPlayerData.PlayerData();
            d.playerID = player;
            MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.add(d);
            return;
        }
        try {
            UUID uuid = UUID.fromString(FilenameUtils.removeExtension((String)path.toFile().getName()));
            if (Objects.equals(uuid, player)) {
                SNBTCompoundTag nbt = SNBT.read((Path)path.toFile().toPath());
                if (nbt == null) {
                    return;
                }
                MarketPlayerData.PlayerData data = new MarketPlayerData.PlayerData();
                data.deserialize((CompoundTag)nbt);
                MarketDataManager.PLAYERS_SERVER_DATA.PLAYERS.add(data);
            }
        }
        catch (Exception e) {
            SDMMarket.printStackTrace("", e);
        }
    }

    public static void saveMarketData(MinecraftServer server) {
        if (USER_SERVER == null) {
            return;
        }
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("SDMMarket/offers/UsersOffers.sdm");
        SNBT.write((Path)path, (CompoundTag)USER_SERVER.serialize());
    }

    public static void loadMarketData(MinecraftServer server) {
        Path path = server.m_129843_(LevelResource.f_78182_).resolve("SDMMarket/offers/UsersOffers.sdm");
        SNBTCompoundTag nbt = SNBT.read((Path)path);
        if (nbt == null) {
            USER_SERVER = new MarketUserData();
            return;
        }
        USER_SERVER = new MarketUserData();
        USER_SERVER.deserialize((CompoundTag)nbt);
    }

    static {
        USER_CLIENT = new MarketUserData();
        GLOBAL_CONFIG_SERVER = new MarketConfig();
        GLOBAL_CONFIG_CLIENT = new MarketConfig();
        PLAYERS_SERVER_DATA = new MarketPlayerData();
        PLAYER_CLIENT_DATA = new MarketPlayerData.PlayerData();
    }
}

