/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.common.data;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.Item;
import net.sixik.sdmmarket.common.data.MarketConfig;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.utils.INBTSerialize;
import org.jetbrains.annotations.Nullable;

public class MarketConfigData
implements INBTSerialize {
    public boolean isServer = false;
    public List<MarketConfigCategory> CATEGORIES = new ArrayList<MarketConfigCategory>();

    public MarketConfigData setServer(boolean server) {
        this.isServer = server;
        return this;
    }

    @Nullable
    public MarketConfigCategory getCategory(UUID uuid) {
        for (MarketConfigCategory category : this.CATEGORIES) {
            if (!Objects.equals(category.categoryID, uuid)) continue;
            return category;
        }
        return null;
    }

    @Nullable
    public AbstractMarketConfigEntry getConfigEntry(Item item) {
        for (MarketConfigCategory category : this.CATEGORIES) {
            for (AbstractMarketConfigEntry entry : category.entries) {
                if (!entry.isAvailable(item.m_7968_())) continue;
                return entry;
            }
        }
        return null;
    }

    public static void save(MinecraftServer server) {
        Path f1;
        if (MarketDataManager.CONFIG_SERVER != null) {
            f1 = Platform.getConfigFolder().resolve("SDMMarket/configData.sdm");
            SNBT.write((Path)f1, (CompoundTag)MarketDataManager.CONFIG_SERVER.serialize());
        }
        if (MarketDataManager.GLOBAL_CONFIG_SERVER != null) {
            f1 = Platform.getConfigFolder().resolve("SDMMarket/globalConfig.sdm");
            SNBT.write((Path)f1, (CompoundTag)MarketDataManager.GLOBAL_CONFIG_SERVER.serialize());
        }
    }

    public static void load(MinecraftServer server) {
        SNBTCompoundTag nbt = SNBT.read((Path)Platform.getConfigFolder().resolve("SDMMarket/configData.sdm"));
        if (nbt != null) {
            MarketDataManager.CONFIG_SERVER = new MarketConfigData();
            MarketDataManager.CONFIG_SERVER.deserialize((CompoundTag)nbt);
        }
        if ((nbt = SNBT.read((Path)Platform.getConfigFolder().resolve("SDMMarket/globalConfig.sdm"))) != null) {
            MarketDataManager.GLOBAL_CONFIG_SERVER = new MarketConfig();
            MarketDataManager.GLOBAL_CONFIG_SERVER.deserialize((CompoundTag)nbt);
        }
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag nbt = new CompoundTag();
        ListTag d1 = new ListTag();
        for (MarketConfigCategory category : this.CATEGORIES) {
            d1.add((Object)category.serialize());
        }
        nbt.m_128365_("categories", (Tag)d1);
        return nbt;
    }

    @Override
    public void deserialize(CompoundTag nbt) {
        if (nbt.m_128441_("categories")) {
            ListTag d1 = (ListTag)nbt.m_128423_("categories");
            this.CATEGORIES.clear();
            for (Tag tag : d1) {
                MarketConfigCategory category = new MarketConfigCategory("");
                category.deserialize((CompoundTag)tag);
                this.CATEGORIES.add(category);
            }
        }
    }
}

