/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.user.selling;

import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.client.gui.user.selling.SellingUserScreen;
import net.sixik.sdmmarket.client.widgets.MarketTextBox;
import net.sixik.sdmmarket.client.widgets.MarketTextField;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.sdmmarket.common.network.user.CreateOfferC2S;
import net.sixik.sdmmarket.common.utils.MarketItemHelper;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.TextRenderHelper;

public class SellingMainUserPanel
extends Panel {
    public int countSell = 0;
    public int priceSell = 0;
    public int countSellOffers = 0;
    public MarketTextField minPrice;
    public MarketTextField maxPrice;
    public MarketTextField countOffers;
    public MarketTextField canBeSell;
    public MarketTextField howSellingText;
    public MarketTextBox howSelling;
    public MarketTextField howPriceText;
    public MarketTextBox howPrice;
    public MarketTextField countOffersText;
    public MarketTextBox countOffersInput;
    public SimpleTextButton acceptSell;
    public SellingUserScreen panel;
    public int countItems = 0;

    public SellingMainUserPanel(SellingUserScreen panel) {
        super((Panel)panel);
        this.panel = panel;
    }

    public void addWidgets() {
        this.recreate();
    }

    public void alignWidgets() {
        this.recreate();
    }

    public void recreate() {
        this.clearWidgets();
        if (!this.panel.selectable.selectedItem.m_41619_()) {
            this.minPrice = new MarketTextField(this);
            this.add((Widget)this.minPrice);
            this.maxPrice = new MarketTextField(this);
            this.add((Widget)this.maxPrice);
            this.minPrice.setWidth(this.width - 38);
            this.minPrice.setMaxWidth(this.width - 38);
            this.minPrice.setPos(38, 4);
            this.maxPrice.setWidth(this.minPrice.width);
            this.maxPrice.setMaxWidth(this.minPrice.maxWidth);
            this.maxPrice.setPos(38, this.minPrice.posY + TextRenderHelper.getTextHeight() + 2);
            boolean f = this.panel.selectable.entry.minPrice > 0L;
            this.minPrice.setText("Min Price: " + (f ? SDMMarket.moneyString(this.panel.selectable.entry.minPrice) : Component.m_237115_((String)"sdm.market.user.create.any_price").getString()));
            f = this.panel.selectable.entry.maxPrice > 0L;
            this.maxPrice.setText("Max Price: " + (f ? SDMMarket.moneyString(this.panel.selectable.entry.maxPrice) : Component.m_237115_((String)"sdm.market.user.create.any_price").getString()));
            this.countOffers = new MarketTextField(this);
            this.add((Widget)this.countOffers);
            this.countOffers.setWidth(this.minPrice.width);
            this.countOffers.setMaxWidth(this.minPrice.maxWidth);
            this.countOffers.setPos(38, this.maxPrice.posY + TextRenderHelper.getTextHeight() + 2);
            this.countOffers.setText((Component)Component.m_237110_((String)"sdm.market.user.create.count_offers", (Object[])new Object[]{MarketDataManager.PLAYER_CLIENT_DATA.countOffers}));
            this.canBeSell = new MarketTextField(this);
            this.add((Widget)this.canBeSell);
            this.countItems = MarketItemHelper.countItems((Player)Minecraft.m_91087_().f_91074_, this.panel.selectable.selectedItem.m_41777_());
            this.canBeSell.setText((Component)Component.m_237110_((String)"sdm.market.user.create.can_sell", (Object[])new Object[]{this.countItems}));
            this.canBeSell.setWidth(this.width - 8);
            this.canBeSell.setMaxWidth(this.width - 8);
            this.canBeSell.setPos(4, 38);
            this.howSellingText = new MarketTextField(this);
            this.add((Widget)this.howSellingText);
            this.howSellingText.setPos(4, this.canBeSell.posY + this.canBeSell.height + 2);
            this.howSellingText.setWidth(this.width / 2);
            this.howSellingText.setText((Component)Component.m_237115_((String)"sdm.market.user.create.how_selling"));
            this.howSelling = new MarketTextBox(this){

                public void onTextChanged() {
                    if (!this.getText().isEmpty()) {
                        SellingMainUserPanel.this.countSell = Integer.parseInt(this.getText());
                        if (SellingMainUserPanel.this.countItems != 0 && SellingMainUserPanel.this.countSell != 0) {
                            SellingMainUserPanel.this.countSellOffers = Math.min(1, SellingMainUserPanel.this.countItems / SellingMainUserPanel.this.countSell);
                            SellingMainUserPanel.this.countOffersInput.setText(String.valueOf(SellingMainUserPanel.this.countSellOffers));
                        }
                    }
                }

                public boolean isValid(String txt) {
                    if (txt.matches("\\d+")) {
                        int i = Integer.parseInt(txt);
                        return i >= 0 && i <= SellingMainUserPanel.this.countItems;
                    }
                    return false;
                }
            };
            this.add((Widget)this.howSelling);
            this.howSelling.ghostText = Component.m_237115_((String)"sdm.market.user.create.write_text").getString();
            this.howSelling.setText(String.valueOf(this.countSell));
            this.howSelling.setPos(5 + this.width / 2, this.canBeSell.posY + this.canBeSell.height + 2);
            this.howSelling.setSize(this.width / 2 - 10, this.howSellingText.height);
            this.howPriceText = new MarketTextField(this);
            this.add((Widget)this.howPriceText);
            this.howPriceText.setPos(4, this.howSellingText.posY + this.howSellingText.height + 2);
            this.howPriceText.setWidth(this.width / 2);
            this.howPriceText.setText((Component)Component.m_237115_((String)"sdm.market.user.create.how_price"));
            this.howPrice = new MarketTextBox(this){

                public void onTextChanged() {
                    if (!this.getText().isEmpty()) {
                        SellingMainUserPanel.this.priceSell = Integer.parseInt(this.getText());
                    }
                }

                public boolean isValid(String txt) {
                    if (txt.matches("\\d+")) {
                        int i = Integer.parseInt(txt);
                        if ((long)i < SellingMainUserPanel.this.panel.selectable.entry.minPrice) {
                            txt = String.valueOf(SellingMainUserPanel.this.panel.selectable.entry.minPrice + 1L);
                            SellingMainUserPanel.this.priceSell = i = (int)(SellingMainUserPanel.this.panel.selectable.entry.minPrice + 1L);
                            this.setText(txt);
                            SellingMainUserPanel.this.panel.refreshWidgets();
                        }
                        if (SellingMainUserPanel.this.panel.selectable.entry.maxPrice == 0L) {
                            return (long)i >= SellingMainUserPanel.this.panel.selectable.entry.minPrice;
                        }
                        return i > 0 && (long)i <= SellingMainUserPanel.this.panel.selectable.entry.maxPrice;
                    }
                    return false;
                }
            };
            this.add((Widget)this.howPrice);
            this.howPrice.ghostText = Component.m_237115_((String)"sdm.market.user.create.write_text").getString();
            this.howPrice.setText(String.valueOf(this.priceSell));
            this.howPrice.setPos(5 + this.width / 2, this.howSellingText.posY + this.howSellingText.height + 2);
            this.howPrice.setSize(this.width / 2 - 10, this.howPriceText.height);
            this.countOffersText = new MarketTextField(this);
            this.add((Widget)this.countOffersText);
            this.countOffersText.setPos(4, this.howPrice.posY + this.howSellingText.height + 2);
            this.countOffersText.setWidth(this.width / 2);
            this.countOffersText.setText((Component)Component.m_237115_((String)"sdm.market.user.create.count_offers_want"));
            this.countOffersInput = new MarketTextBox(this){

                public void onTextChanged() {
                    if (!this.getText().isEmpty()) {
                        SellingMainUserPanel.this.countSellOffers = Integer.parseInt(this.getText());
                    }
                }

                public boolean isValid(String txt) {
                    if (txt.matches("\\d+")) {
                        int i = Integer.parseInt(txt);
                        if (SellingMainUserPanel.this.countItems != 0 && SellingMainUserPanel.this.countSell != 0) {
                            SellingMainUserPanel.this.countSellOffers = SellingMainUserPanel.this.countItems / SellingMainUserPanel.this.countSell;
                            return i > 0 && i <= SellingMainUserPanel.this.countSellOffers;
                        }
                    }
                    return false;
                }
            };
            this.add((Widget)this.countOffersInput);
            this.countOffersInput.ghostText = Component.m_237115_((String)"sdm.market.user.create.write_text").getString();
            this.countOffersInput.setText(String.valueOf(this.countSellOffers));
            this.countOffersInput.setPos(5 + this.width / 2, this.howPrice.posY + this.howSellingText.height + 2);
            this.countOffersInput.setSize(this.width / 2 - 10, this.howPriceText.height);
            this.acceptSell = new SimpleTextButton(this, (Component)Component.m_237115_((String)"sdm.market.user.create.create_lot"), Icons.ADD){

                public void onClicked(MouseButton button) {
                    if (button.isLeft() && SellingMainUserPanel.this.countSellOffers > 0) {
                        try {
                            for (int i = 0; i < SellingMainUserPanel.this.countSellOffers; ++i) {
                                MarketUserEntry entry = new MarketUserEntry(SellingMainUserPanel.this.panel.selectable.configCategory.categoryID);
                                entry.itemStack = SellingMainUserPanel.this.panel.selectable.selectedItem.m_41777_();
                                entry.price = SellingMainUserPanel.this.priceSell;
                                entry.count = SellingMainUserPanel.this.countSell;
                                entry.ownerID = Minecraft.m_91087_().f_91074_.m_36316_().getId();
                                new CreateOfferC2S(entry.serialize()).sendToServer();
                            }
                            ((SellingUserScreen)this.getGui()).mainUserPanel.priceSell = 0;
                            ((SellingUserScreen)this.getGui()).mainUserPanel.countItems = 0;
                            ((SellingUserScreen)this.getGui()).mainUserPanel.countSell = 0;
                            ((SellingUserScreen)this.getGui()).sellingPanel.addSellableItems();
                            ((SellingUserScreen)this.getGui()).mainUserPanel.recreate();
                        }
                        catch (Exception e) {
                            SDMMarket.printStackTrace("", e);
                        }
                        this.getGui().closeGui();
                    }
                }

                public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    if (SellingMainUserPanel.this.canCreate()) {
                        super.draw(graphics, theme, x, y, w, h);
                    }
                }

                public boolean checkMouseOver(int mouseX, int mouseY) {
                    return SellingMainUserPanel.this.canCreate() && super.checkMouseOver(mouseX, mouseY);
                }

                public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                    RGBA.create((int)100, (int)100, (int)100, (int)85).drawRoundFill(graphics, x, y, w, h, 2);
                }

                public boolean renderTitleInCenter() {
                    return true;
                }
            };
            this.add((Widget)this.acceptSell);
            this.acceptSell.setSize(this.width - 8, TextRenderHelper.getTextHeight() + 3);
            this.acceptSell.setPos(4, this.height - (TextRenderHelper.getTextHeight() + 5));
        }
    }

    public boolean canCreate() {
        boolean flag1 = MarketDataManager.PLAYER_CLIENT_DATA.countOffers > 0;
        boolean flag2 = this.countSell > 0;
        boolean flag3 = (long)this.priceSell >= this.panel.selectable.entry.minPrice;
        return flag1 && flag2 && flag3;
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        int x1 = x + 4;
        int y1 = y + 4;
        RGBA.create((int)100, (int)100, (int)100, (int)85).drawRoundFill(graphics, x1, y1, 32, 32, 6);
        if (!this.panel.selectable.selectedItem.m_41619_()) {
            ItemIcon.getItemIcon((ItemStack)this.panel.selectable.selectedItem).draw(graphics, x1, y1, 32, 32);
        }
    }
}

