/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.user.search;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdm_economy.api.CurrencyHelper;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.client.SearchData;
import net.sixik.sdmmarket.client.gui.user.MarketUserScreen;
import net.sixik.sdmmarket.client.gui.user.search.SearchCategoriesPanel;
import net.sixik.sdmmarket.client.widgets.MarketCheckBox;
import net.sixik.sdmmarket.client.widgets.MarketTextBox;
import net.sixik.sdmmarket.client.widgets.MarketTextField;
import net.sixik.v2.color.Colors;
import net.sixik.v2.color.RGB;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.TextRenderHelper;

public class SearchPanel
extends Panel {
    public TextBox searchBox;
    public TextBox minPriceBox;
    public TextBox maxPriceBox;
    public TextField categoryTitle;
    public SearchCategoriesPanel categoriesPanel;
    public PanelScrollBar scrollCategoriesPanel;
    public Button resetButton;
    public MarketTextField moneyField;
    public MarketCheckBox isEcnabledCheckBox;
    public MarketCheckBox isNoDamageCheckBox;
    public TextBox minCountBox;
    public TextBox maxCountBox;

    public SearchPanel(Panel panel) {
        super(panel);
    }

    public void addWidgets() {
        this.searchBox = new MarketTextBox(this){

            public void onTextChanged() {
                SearchData.name = SearchPanel.this.searchBox.getText();
                ((MarketUserScreen)this.getGui()).refreshEntries();
            }
        };
        this.add((Widget)this.searchBox);
        this.minPriceBox = new MarketTextBox(this){

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.m_237115_((String)"sdm.market.user.minprice.tooltip"));
            }

            public void onTextChanged() {
                if (!SearchPanel.this.minPriceBox.getText().isEmpty()) {
                    SearchData.priceFrom = Integer.parseInt(SearchPanel.this.minPriceBox.getText());
                    ((MarketUserScreen)this.getGui()).refreshEntries();
                }
            }

            public boolean isValid(String txt) {
                if (txt.matches("\\d+")) {
                    long d = Integer.parseInt(txt);
                    if (SearchData.priceTo > 0L && d >= SearchData.priceTo) {
                        d = SearchData.priceTo - 1L;
                        txt = String.valueOf(d);
                        this.setText(txt);
                        SearchPanel.this.refreshWidgets();
                    }
                    if (SearchData.priceTo > 0L) {
                        return d < SearchData.priceTo;
                    }
                    return true;
                }
                return false;
            }
        };
        this.add((Widget)this.minPriceBox);
        this.maxPriceBox = new MarketTextBox(this){

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.m_237115_((String)"sdm.market.user.maxprice.tooltip"));
            }

            public void onTextChanged() {
                if (!SearchPanel.this.maxPriceBox.getText().isEmpty()) {
                    SearchData.priceTo = Integer.parseInt(SearchPanel.this.maxPriceBox.getText());
                    ((MarketUserScreen)this.getGui()).refreshEntries();
                }
            }

            public boolean isValid(String txt) {
                if (txt.matches("\\d+")) {
                    long d = Integer.parseInt(txt);
                    if (SearchData.priceFrom > 0L && d <= SearchData.priceFrom) {
                        d = SearchData.priceFrom + 1L;
                        txt = String.valueOf(d);
                        this.setText(txt);
                        SearchPanel.this.refreshWidgets();
                    }
                    if (SearchData.priceFrom > 0L) {
                        return d > SearchData.priceFrom;
                    }
                    return true;
                }
                return false;
            }
        };
        this.add((Widget)this.maxPriceBox);
        this.minCountBox = new MarketTextBox(this){

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.m_237115_((String)"sdm.market.user.mincount.tooltip"));
            }

            public void onTextChanged() {
                if (!SearchPanel.this.minCountBox.getText().isEmpty()) {
                    SearchData.countFrom = Integer.parseInt(SearchPanel.this.minCountBox.getText());
                    ((MarketUserScreen)this.getGui()).refreshEntries();
                }
            }

            public boolean isValid(String txt) {
                if (txt.matches("\\d+")) {
                    long d = Integer.parseInt(txt);
                    if (SearchData.countTo > 0 && d >= (long)SearchData.countTo) {
                        d = SearchData.countTo - 1;
                        txt = String.valueOf(d);
                        this.setText(txt);
                        SearchPanel.this.refreshWidgets();
                    }
                    if (SearchData.countTo > 0) {
                        return d < (long)SearchData.countTo;
                    }
                    return true;
                }
                return false;
            }
        };
        this.add((Widget)this.minCountBox);
        this.maxCountBox = new MarketTextBox(this){

            public void addMouseOverText(TooltipList list) {
                list.add((Component)Component.m_237115_((String)"sdm.market.user.maxcount.tooltip"));
            }

            public void onTextChanged() {
                if (!SearchPanel.this.maxCountBox.getText().isEmpty()) {
                    SearchData.countTo = Integer.parseInt(SearchPanel.this.maxCountBox.getText());
                    ((MarketUserScreen)this.getGui()).refreshEntries();
                }
            }

            public boolean isValid(String txt) {
                if (txt.matches("\\d+")) {
                    long d = Integer.parseInt(txt);
                    if (SearchData.countFrom > 0 && d <= (long)SearchData.countFrom) {
                        d = SearchData.countFrom + 1;
                        txt = String.valueOf(d);
                        this.setText(txt);
                        SearchPanel.this.refreshWidgets();
                    }
                    if (SearchData.countFrom > 0) {
                        return d > (long)SearchData.countFrom;
                    }
                    return true;
                }
                return false;
            }
        };
        this.add((Widget)this.maxCountBox);
        this.categoryTitle = new TextField((Panel)this);
        this.add((Widget)this.categoryTitle);
        this.categoryTitle.setText((Component)Component.m_237115_((String)"sdm.market.user.categories.title"));
        this.categoriesPanel = new SearchCategoriesPanel(this);
        this.add((Widget)this.categoriesPanel);
        this.categoriesPanel.addWidgets();
        this.scrollCategoriesPanel = new PanelScrollBar(this, this.categoriesPanel){

            public void drawScrollBar(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                Colors.UI_GOLD_0.draw(graphics, x, y, w, h);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.scrollCategoriesPanel);
        this.resetButton = new SimpleTextButton(this, (Component)Component.m_237113_((String)"Reset"), (Icon)Icon.empty()){

            public void onClicked(MouseButton button) {
                if (button.isLeft()) {
                    SearchData.reset();
                    this.parent.refreshWidgets();
                    ((MarketUserScreen)this.getGui()).refreshEntries();
                }
            }

            public boolean renderTitleInCenter() {
                return true;
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)100, (int)100, (int)100, (int)85).drawRoundFill(graphics, x, y, w, h, 4);
            }
        };
        this.add((Widget)this.resetButton);
        this.moneyField = new MarketTextField(this);
        this.add((Widget)this.moneyField);
        this.moneyField.setText(SDMMarket.moneyString(CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_)));
        this.isEcnabledCheckBox = new MarketCheckBox(this){

            @Override
            public void onClicked(MouseButton button) {
                super.onClicked(button);
                SearchData.isEncantable = this.isChecked;
                ((MarketUserScreen)this.getGui()).refreshEntries();
            }
        };
        this.add((Widget)this.isEcnabledCheckBox);
        this.isEcnabledCheckBox.setSelected(SearchData.isEncantable);
        this.isEcnabledCheckBox.setTitle((Component)Component.m_237115_((String)"sdm.market.user.search.isenchantable"));
        this.isNoDamageCheckBox = new MarketCheckBox(this){

            @Override
            public void onClicked(MouseButton button) {
                super.onClicked(button);
                SearchData.isNoDamaged = this.isChecked;
                ((MarketUserScreen)this.getGui()).refreshEntries();
            }
        };
        this.add((Widget)this.isNoDamageCheckBox);
        this.isNoDamageCheckBox.setSelected(SearchData.isNoDamaged);
        this.isNoDamageCheckBox.setTitle((Component)Component.m_237115_((String)"sdm.market.user.search.isnodamaged"));
        this.searchBox.setText(SearchData.name);
        this.searchBox.ghostText = Component.m_237115_((String)"sdm.market.user.search.ghost_text").getString();
        this.minPriceBox.setText(SearchData.priceFrom > 0L ? String.valueOf(SearchData.priceFrom) : "");
        this.minPriceBox.ghostText = "\u25ce 0";
        this.maxPriceBox.setText(SearchData.priceTo > 0L ? String.valueOf(SearchData.priceTo) : "");
        this.maxPriceBox.ghostText = "\u25ce 1000";
        this.minCountBox.setText(SearchData.countFrom > 0 ? String.valueOf(SearchData.countFrom) : "");
        this.minCountBox.ghostText = "0";
        this.maxCountBox.setText(SearchData.countTo > 0 ? String.valueOf(SearchData.countTo) : "");
        this.maxCountBox.ghostText = "1000";
        this.setProperty();
    }

    public void alignWidgets() {
        this.setProperty();
    }

    public void setProperty() {
        this.searchBox.setPos(4, 4);
        this.searchBox.setSize(this.width - 8, TextRenderHelper.getTextHeight() + 2);
        int wight = (this.width - this.width / 8 - 4) / 2;
        this.minPriceBox.setPos(4, this.searchBox.posY + this.searchBox.height + 2);
        this.minPriceBox.setSize(wight, TextRenderHelper.getTextHeight() + 2);
        this.maxPriceBox.setPos(this.width - wight - 4, this.searchBox.posY + this.searchBox.height + 2);
        this.maxPriceBox.setSize(wight, TextRenderHelper.getTextHeight() + 2);
        this.minCountBox.setPos(4, this.minPriceBox.posY + this.minPriceBox.height + 2);
        this.minCountBox.setSize(wight, TextRenderHelper.getTextHeight() + 2);
        this.maxCountBox.setPos(this.width - wight - 4, this.minPriceBox.posY + this.minPriceBox.height + 2);
        this.maxCountBox.setSize(wight, TextRenderHelper.getTextHeight() + 2);
        this.categoryTitle.setPos(4, this.minCountBox.posY + this.minCountBox.height + 4);
        this.categoryTitle.setSize(this.width - 8, TextRenderHelper.getTextHeight());
        this.categoriesPanel.setPos(4, this.categoryTitle.posY + this.categoryTitle.height + 2);
        int elementHeight = TextRenderHelper.getTextHeight() + 1 + 2;
        this.categoriesPanel.setSize(this.width - 8, elementHeight * 6 + 2);
        this.resetButton.setPos(4, this.height - (TextRenderHelper.getTextHeight() + 2) * 2 - 2 - 1);
        this.resetButton.setSize(this.width - 8, TextRenderHelper.getTextHeight() + 1);
        this.moneyField.setWidth(this.width - 8);
        this.moneyField.setHeight(TextRenderHelper.getTextHeight());
        this.moneyField.setPos(4, this.height - (TextRenderHelper.getTextHeight() + 3));
        this.categoriesPanel.alignWidgets();
        this.isEcnabledCheckBox.setPos(4, this.categoriesPanel.posY + this.categoriesPanel.height + 2);
        this.isEcnabledCheckBox.setSize(this.width - 8, TextRenderHelper.getTextHeight() + 1);
        this.isNoDamageCheckBox.setPos(4, this.isEcnabledCheckBox.posY + this.isEcnabledCheckBox.height + 2);
        this.isNoDamageCheckBox.setSize(this.width - 8, TextRenderHelper.getTextHeight() + 1);
        this.scrollCategoriesPanel.setPosAndSize(this.categoriesPanel.getPosX() + this.categoriesPanel.getWidth() - this.getScrollbarWidth(), this.categoriesPanel.getPosY(), this.getScrollbarWidth(), this.categoriesPanel.getHeight());
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        int a = this.minPriceBox.posX + this.minPriceBox.width;
        int b = this.maxPriceBox.posX + this.maxPriceBox.width;
        RGB.create((int)255, (int)255, (int)255).draw(graphics, x + this.minPriceBox.posX + this.minPriceBox.width + 2, y + this.minPriceBox.posY + this.minPriceBox.height / 2, b - a - 4 - this.minPriceBox.width, 1);
        RGB.create((int)255, (int)255, (int)255).draw(graphics, x + this.minCountBox.posX + this.minCountBox.width + 2, y + this.minCountBox.posY + this.minCountBox.height / 2, b - a - 4 - this.minCountBox.width, 1);
    }

    protected int getScrollbarWidth() {
        return 2;
    }
}

