/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.user.buyer;

import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.client.gui.user.buyer.MarketUserBuyerEntriesPanel;
import net.sixik.sdmmarket.common.market.user.MarketUserEntry;
import net.sixik.v2.color.RGBA;

public class MarketUserBuyerEntryButton
extends SimpleTextButton {
    public MarketUserEntry entry;
    public MarketUserBuyerEntriesPanel panel;

    public MarketUserBuyerEntryButton(MarketUserBuyerEntriesPanel panel, MarketUserEntry entry) {
        super((Panel)panel, (Component)Component.m_237119_(), (Icon)Icon.empty());
        this.panel = panel;
        this.entry = entry;
        this.setTitle((Component)Component.m_237113_((String)SDMMarket.moneyString(entry.price)));
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            this.panel.panel.selectedEntry = this.entry;
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.panel.panel.selectedEntry != null && Objects.equals(this.panel.panel.selectedEntry.entryID, this.entry.entryID)) {
            RGBA.create((int)255, (int)255, (int)255, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        } else {
            RGBA.create((int)100, (int)100, (int)100, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
        }
    }

    public void addMouseOverText(TooltipList list) {
        this.entry.itemStack.m_41651_((Player)Minecraft.m_91087_().f_91074_, (TooltipFlag)TooltipFlag.f_256752_).forEach(arg_0 -> ((TooltipList)list).add(arg_0));
        if (this.entry.itemStack.m_41763_() && this.entry.itemStack.m_41768_()) {
            list.add((Component)Component.m_237113_((String)("Damage: " + (this.entry.itemStack.m_41776_() - this.entry.itemStack.m_41773_()) + "/" + this.entry.itemStack.m_41776_())));
        }
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237110_((String)"sdm.market.user.buy.price", (Object[])new Object[]{this.entry.price}));
        list.add((Component)Component.m_237110_((String)"sdm.market.user.buy.count", (Object[])new Object[]{this.entry.count}));
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        this.drawBackground(graphics, theme, x, y, w, h);
        int s = h >= 16 ? 16 : 8;
        int off = (h - s) / 2;
        Component title = this.getTitle();
        int textX = x;
        int textY = y + (h - theme.getFontHeight() + 1) / 2;
        int sw = theme.getStringWidth((FormattedText)title);
        int mw = w - (this.hasIcon() ? off + s : 0) - 6;
        if (sw > mw) {
            sw = mw;
            title = theme.trimStringToWidth((FormattedText)title, mw);
        }
        textX = this.renderTitleInCenter() ? (textX += (mw - sw + 6) / 2) : (textX += 4);
        if (this.hasIcon()) {
            this.drawIcon(graphics, theme, x + off, y + off, s, s);
            textX += off + s;
        }
        theme.drawString(graphics, (Object)title, textX, textY, theme.getContentColor(this.getWidgetType()), 2);
        int f = this.width / 2;
        String d = String.valueOf(this.entry.count) + " qty";
        theme.drawString(graphics, (Object)d, x + f + f / 4, textY, theme.getContentColor(this.getWidgetType()), 2);
    }
}

