/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.admin.entry;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmmarket.SDMMarket;
import net.sixik.sdmmarket.client.gui.admin.MarketAdminScreen;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.DurabilityMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.ItemTagMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.network.admin.CreateCategoryEntryC2S;
import net.sixik.sdmmarket.common.network.admin.EditCategoryEntryC2S;
import net.sixik.v2.color.RGBA;
import net.sixik.v2.render.GLRenderHelper;
import net.sixik.v2.render.TextRenderHelper;
import net.sixik.v2.utils.math.Vector2;
import net.sixik.v2.utils.math.Vector2f;

public class EntryButton
extends SimpleTextButton {
    public boolean isEdit = false;
    public List<Holder<Item>> items = new ArrayList<Holder<Item>>();
    public AbstractMarketConfigEntry configEntry;
    private int i = 0;
    private int currentIndex = 0;

    public EntryButton(Panel panel, AbstractMarketConfigEntry configEntry) {
        super(panel, (Component)Component.m_237119_(), (Icon)(configEntry != null ? configEntry.getIcon() : Icon.empty()));
        this.configEntry = configEntry;
        if (configEntry instanceof ItemTagMarketConfigEntry) {
            ItemTagMarketConfigEntry configEntry1 = (ItemTagMarketConfigEntry)configEntry;
            this.items = configEntry1.getItems().get().m_203614_().toList();
        }
    }

    public EntryButton setEdit() {
        this.isEdit = true;
        this.setIcon(Icons.ADD);
        return this;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (this.isEdit) {
                ArrayList<ContextMenuItem> fContext1 = new ArrayList<ContextMenuItem>();
                fContext1.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.admin.entry.tool"), Icons.ADD, d -> {
                    MarketConfigCategory category = ((MarketAdminScreen)this.getGui()).selectedCategory;
                    DurabilityMarketConfigEntry entry = new DurabilityMarketConfigEntry(category.categoryID, Items.f_42127_.m_7968_());
                    category.entries.add(entry);
                    ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
                    new CreateCategoryEntryC2S(category.categoryID, entry.serialize()).sendToServer();
                }));
                fContext1.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.admin.entry.item"), Icons.ADD, d -> {
                    MarketConfigCategory category = ((MarketAdminScreen)this.getGui()).selectedCategory;
                    ItemMarketConfigEntry entry = new ItemMarketConfigEntry(category.categoryID, Items.f_42127_.m_7968_());
                    category.entries.add(entry);
                    ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
                    new CreateCategoryEntryC2S(category.categoryID, entry.serialize()).sendToServer();
                }));
                fContext1.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.admin.entry.tag"), Icons.ADD, d -> {
                    MarketConfigCategory category = ((MarketAdminScreen)this.getGui()).selectedCategory;
                    ItemTagMarketConfigEntry entry = new ItemTagMarketConfigEntry(category.categoryID);
                    category.entries.add(entry);
                    ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
                    new CreateCategoryEntryC2S(category.categoryID, entry.serialize()).sendToServer();
                }));
                this.getGui().openContextMenu(fContext1);
            } else {
                this.editScreen();
            }
        } else if (button.isRight() && !this.isEdit) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.admin.edit"), Icons.SETTINGS, d -> this.editScreen()));
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.delete"), Icons.REMOVE, d -> {
                ((MarketAdminScreen)this.getGui()).selectedCategory.entries.removeIf(s -> s.equals(this.configEntry));
                ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
                new EditCategoryEntryC2S(((MarketAdminScreen)this.getGui()).selectedCategory.categoryID, this.configEntry.entryID, new CompoundTag()).sendToServer();
            }));
            this.getGui().openContextMenu(contextMenu);
        }
    }

    public void addMouseOverText(TooltipList list) {
        if (!this.isEdit) {
            ItemStack itemStack = ItemStack.f_41583_;
            AbstractMarketConfigEntry abstractMarketConfigEntry = this.configEntry;
            if (abstractMarketConfigEntry instanceof ItemTagMarketConfigEntry) {
                ItemTagMarketConfigEntry tEntry = (ItemTagMarketConfigEntry)abstractMarketConfigEntry;
                list.add((Component)Component.m_237113_((String)"Tag: ").m_130946_(tEntry.tagKey.toString()));
            } else {
                abstractMarketConfigEntry = this.configEntry.getIcon();
                if (abstractMarketConfigEntry instanceof ItemIcon) {
                    ItemIcon icon = (ItemIcon)abstractMarketConfigEntry;
                    itemStack = icon.getStack();
                }
            }
            if (!itemStack.m_41619_()) {
                list.add(itemStack.m_41611_());
            }
            list.add((Component)Component.m_237113_((String)("Min Price: " + (this.configEntry.minPrice > 0L ? SDMMarket.moneyString(this.configEntry.minPrice) : "Any Price"))));
            list.add((Component)Component.m_237113_((String)("Max Price: " + (this.configEntry.maxPrice > 0L ? SDMMarket.moneyString(this.configEntry.maxPrice) : "Any Price"))));
        }
    }

    public void editScreen() {
        ConfigGroup group = new ConfigGroup("entry", b -> {
            this.openGui();
            if (b) {
                new EditCategoryEntryC2S(((MarketAdminScreen)this.getGui()).selectedCategory.categoryID, this.configEntry.entryID, this.configEntry.serialize()).sendToServer();
            }
        }).setNameKey("sidebar_button.sdm.market");
        ConfigGroup g = group.getOrCreateSubgroup("market").getOrCreateSubgroup("entry");
        this.configEntry.config(g);
        new EditConfigScreen(group).openGui();
        this.getGui().refreshWidgets();
    }

    public void draw(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isEdit) {
            super.draw(graphics, theme, x, y, w, h);
            return;
        }
        GuiHelper.setupDrawing();
        int s = h >= 16 ? 16 : 8;
        this.drawBackground(graphics, theme, x, y, w, h);
        this.drawIcon(graphics, theme, x + (w - s) / 2, y + 2, s, s);
        if (this.configEntry != null) {
            String text = "Any Price";
            if (this.configEntry.minPrice > 0L) {
                text = SDMMarket.moneyString(this.configEntry.minPrice);
            }
            Vector2f size = TextRenderHelper.getTextRenderSize((String)text, (int)w, (float)1.0f, (int)50);
            GLRenderHelper.pushTransform((GuiGraphics)graphics, (Vector2)new Vector2(x, y), (Vector2)new Vector2(1, 1), (float)size.y, (float)0.0f);
            theme.drawString(graphics, (Object)text, x + 1, y + (h - theme.getFontHeight() - 1));
            GLRenderHelper.popTransform((GuiGraphics)graphics);
        }
        if (this.items.isEmpty() || this.items.size() == 1) {
            this.currentIndex = 0;
            return;
        }
        ++this.i;
        if (this.i % 40 == 0) {
            ++this.currentIndex;
            if (this.currentIndex >= this.items.size()) {
                this.currentIndex = 0;
            }
            this.icon = ItemIcon.getItemIcon((Item)((Item)this.items.get(this.currentIndex).m_203334_()));
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 6);
    }
}

