/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.admin.category;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ui.EditConfigScreen;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.sixik.sdmmarket.client.gui.admin.MarketAdminScreen;
import net.sixik.sdmmarket.client.gui.admin.category.CategoryPanel;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.network.admin.CreateCategoryC2S;
import net.sixik.sdmmarket.common.network.admin.EditCategoryC2S;
import net.sixik.sdmmarket.common.register.CustomIconItem;
import net.sixik.v2.color.RGBA;

public class CategoryButton
extends SimpleTextButton {
    public boolean isEdit = false;
    public CategoryPanel parentPanel;
    public MarketConfigCategory category;

    public CategoryButton(CategoryPanel panel, MarketConfigCategory category) {
        super((Panel)panel, (Component)(category != null ? Component.m_237113_((String)category.categoryName) : Component.m_237119_()), (Icon)(category != null ? CustomIconItem.getIcon(category.icon) : Icon.empty()));
        this.parentPanel = panel;
        this.category = category;
    }

    public CategoryButton setEdit() {
        this.isEdit = true;
        this.setIcon(Icons.ADD);
        this.setTitle((Component)Component.m_237113_((String)"Create"));
        return this;
    }

    public void onClicked(MouseButton button) {
        if (button.isLeft()) {
            if (this.isEdit) {
                MarketConfigCategory category = new MarketConfigCategory("Empty Name");
                MarketDataManager.CONFIG_CLIENT.CATEGORIES.add(category);
                ((MarketAdminScreen)this.getGui()).addCategoryButtons();
                new CreateCategoryC2S(category.serialize()).sendToServer();
            } else {
                ((MarketAdminScreen)this.getGui()).selectedCategory = this.category;
                ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
            }
        } else if (button.isRight() && !this.isEdit) {
            ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.admin.edit"), Icons.SETTINGS, d -> this.editScreen()));
            contextMenu.add(new ContextMenuItem((Component)Component.m_237115_((String)"sdm.market.delete"), Icons.REMOVE, d -> {
                if (MarketDataManager.CONFIG_CLIENT.CATEGORIES.removeIf(s -> s.categoryID.equals(this.category.categoryID))) {
                    if (Objects.equals(((MarketAdminScreen)this.getGui()).selectedCategory, this.category)) {
                        ((MarketAdminScreen)this.getGui()).selectedCategory = null;
                        ((MarketAdminScreen)this.getGui()).addCategoryEntryButtons();
                    }
                    ((MarketAdminScreen)this.getGui()).addCategoryButtons();
                    new EditCategoryC2S(this.category.categoryID, new CompoundTag()).sendToServer();
                }
                this.getGui().refreshWidgets();
            }));
            this.getGui().openContextMenu(contextMenu);
        }
    }

    public void editScreen() {
        ConfigGroup group = new ConfigGroup("category", b -> {
            this.openGui();
            if (b) {
                new EditCategoryC2S(this.category.categoryID, this.category.serialize()).sendToServer();
            }
        }).setNameKey("sidebar_button.sdm.market");
        ConfigGroup g = group.getOrCreateSubgroup("market").getOrCreateSubgroup("category");
        this.category.config(g);
        new EditConfigScreen(group).openGui();
        this.getGui().refreshWidgets();
    }

    public void addMouseOverText(TooltipList list) {
        if (!this.isEdit) {
            super.addMouseOverText(list);
        } else if (Screen.m_96638_()) {
            list.add((Component)Component.m_237115_((String)"sdm.market.admin.edit.description_1"));
            list.add((Component)Component.m_237115_((String)"sdm.market.admin.edit.description_2"));
            list.add((Component)Component.m_237115_((String)"sdm.market.admin.edit.description_3"));
            list.add((Component)Component.m_237115_((String)"sdm.market.admin.edit.description_4"));
        } else {
            list.add((Component)Component.m_237115_((String)"sdm.market.shift_info"));
        }
    }

    public boolean isSelected() {
        return this.category != null && ((MarketAdminScreen)this.getGui()).selectedCategory == this.category;
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
        if (this.isSelected()) {
            RGBA.create((int)255, (int)255, (int)255, (int)85).drawRoundFill(graphics, x, y, w, h, 2);
        } else {
            RGBA.create((int)0, (int)0, (int)0, (int)85).drawRoundFill(graphics, x, y, w, h, 2);
        }
    }
}

