/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmmarket.client.gui.admin;

import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.ScreenWrapper;
import dev.ftb.mods.ftblibrary.ui.ScrollBar;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.sixik.sdmmarket.client.gui.admin.MarketAdminGlobalConfigButton;
import net.sixik.sdmmarket.client.gui.admin.category.CategoryButton;
import net.sixik.sdmmarket.client.gui.admin.category.CategoryPanel;
import net.sixik.sdmmarket.client.gui.admin.entry.EntryButton;
import net.sixik.sdmmarket.client.gui.admin.entry.EntryPanel;
import net.sixik.sdmmarket.common.data.MarketDataManager;
import net.sixik.sdmmarket.common.market.config.AbstractMarketConfigEntry;
import net.sixik.sdmmarket.common.market.config.MarketConfigCategory;
import net.sixik.sdmmarket.common.network.admin.InvokeSyncAdminCategoryC2S;
import net.sixik.v2.color.Colors;
import net.sixik.v2.color.RGBA;

public class MarketAdminScreen
extends BaseScreen {
    public MarketConfigCategory selectedCategory = null;
    public CategoryPanel categoryPanel;
    public EntryPanel entryPanel;
    public PanelScrollBar scrollCategoryPanel;
    public PanelScrollBar scrollEntryPanel;
    public MarketAdminGlobalConfigButton globalConfigButton;
    public int sizeOfButtons = 48;

    public MarketAdminScreen() {
        new InvokeSyncAdminCategoryC2S().sendToServer();
    }

    public boolean onInit() {
        this.setWidth(this.getScreen().m_85445_() * 4 / 5);
        this.setHeight(this.getScreen().m_85446_() * 4 / 5);
        this.closeContextMenu();
        return true;
    }

    public void addWidgets() {
        this.globalConfigButton = new MarketAdminGlobalConfigButton((Panel)this);
        this.add((Widget)this.globalConfigButton);
        this.categoryPanel = new CategoryPanel(this);
        this.add((Widget)this.categoryPanel);
        this.scrollCategoryPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.categoryPanel){

            public void drawScrollBar(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                Colors.UI_GOLD_0.draw(graphics, x, y, w, h);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.scrollCategoryPanel);
        this.entryPanel = new EntryPanel(this);
        this.add((Widget)this.entryPanel);
        this.scrollEntryPanel = new PanelScrollBar((Panel)this, ScrollBar.Plane.VERTICAL, this.entryPanel){

            public void drawScrollBar(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                Colors.UI_GOLD_0.draw(graphics, x, y, w, h);
            }

            public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
                RGBA.create((int)0, (int)0, (int)0, (int)127).draw(graphics, x, y, w, h);
            }
        };
        this.add((Widget)this.scrollEntryPanel);
        this.addCategoryButtons();
        this.addCategoryEntryButtons();
    }

    public void alignWidgets() {
        this.globalConfigButton.setPos(this.width + 2, 0);
        this.categoryPanel.setSize(this.width / 5, this.height);
        this.entryPanel.setX(this.width / 5 + 2);
        this.entryPanel.setSize(this.width - 2 - this.width / 5, this.height);
        this.scrollCategoryPanel.setPosAndSize(this.categoryPanel.getPosX() + this.categoryPanel.getWidth() - this.getScrollbarWidth(), this.categoryPanel.getPosY(), this.getScrollbarWidth(), this.categoryPanel.getHeight());
        this.scrollEntryPanel.setPosAndSize(this.entryPanel.getPosX() + this.entryPanel.getWidth() - this.getScrollbarWidth(), this.entryPanel.getPosY(), this.getScrollbarWidth(), this.entryPanel.getHeight() - 10);
        this.addCategoryButtons();
        this.addCategoryEntryButtons();
    }

    public void addCategoryEntryButtons() {
        if (this.selectedCategory != null) {
            this.entryPanel.clearWidgets();
            ArrayList<EntryButton> list = new ArrayList<EntryButton>();
            for (AbstractMarketConfigEntry entry : this.selectedCategory.entries) {
                EntryButton button = new EntryButton(this.entryPanel, entry);
                button.setSize(this.sizeOfButtons, this.sizeOfButtons);
                list.add(button);
            }
            EntryButton button = new EntryButton(this.entryPanel, null);
            button.setEdit();
            button.setSize(this.sizeOfButtons, this.sizeOfButtons);
            list.add(button);
            this.calculatePositionsEntry(list);
            this.entryPanel.addAll(list);
        }
    }

    public void calculatePositionsEntry(List<EntryButton> list) {
        int x = 2;
        int y = 2;
        for (EntryButton button : list) {
            if (x + 2 + button.width >= this.entryPanel.width) {
                button.setPos(2, y += button.height + 2);
                x = button.width + 4;
                continue;
            }
            button.setPos(x, y);
            x += button.width + 2;
        }
    }

    public void addCategoryButtons() {
        this.categoryPanel.getWidgets().clear();
        ArrayList<CategoryButton> list = new ArrayList<CategoryButton>();
        for (MarketConfigCategory category : MarketDataManager.CONFIG_CLIENT.CATEGORIES) {
            CategoryButton button = new CategoryButton(this.categoryPanel, category);
            button.setSize(this.categoryPanel.width, 18);
            list.add(button);
        }
        CategoryButton button = new CategoryButton(this.categoryPanel, null);
        button.setSize(this.categoryPanel.width, 18);
        button.setEdit();
        list.add(button);
        this.calculatePositions(list);
        list.forEach(arg_0 -> ((CategoryPanel)this.categoryPanel).add(arg_0));
    }

    public void calculatePositions(List<CategoryButton> list) {
        int i = 0;
        for (CategoryButton button : list) {
            button.setPos(0, i);
            i += button.height + 2;
        }
    }

    public void drawBackground(GuiGraphics graphics, Theme theme, int x, int y, int w, int h) {
    }

    protected int getScrollbarWidth() {
        return 2;
    }

    public static void refreshIfOpen() {
        ScreenWrapper wrapper;
        BaseScreen baseScreen;
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof ScreenWrapper && (baseScreen = (wrapper = (ScreenWrapper)screen).getGui()) instanceof MarketAdminScreen) {
            MarketAdminScreen adminScreen = (MarketAdminScreen)baseScreen;
            adminScreen.refreshWidgets();
        }
    }
}

