/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.utils;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PositionUtils {
    public static Vec2 rotationToFace(Vec3 rotatingFrom, Vec3 facing) {
        double x = facing.f_82479_ - rotatingFrom.f_82479_;
        double y = facing.f_82480_ - rotatingFrom.f_82480_;
        double z = facing.f_82481_ - rotatingFrom.f_82481_;
        double distance = Math.sqrt(x * x + z * z);
        float yRot = (float)(Mth.m_14136_((double)z, (double)x) * 57.2957763671875) - 90.0f;
        float xRot = (float)(-(Mth.m_14136_((double)y, (double)distance) * 57.2957763671875));
        return new Vec2(xRot, yRot);
    }

    public static boolean hasLineOfSight(Entity entitySearching, Vec3 targetPos) {
        Vec3 vec31 = new Vec3(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
        Vec3 vec3 = new Vec3(entitySearching.m_20185_(), entitySearching.m_20188_(), entitySearching.m_20189_());
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        BlockHitResult clip = entitySearching.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySearching));
        return clip.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Entity entitySearching, BlockPos targetPos) {
        Vec3 vec3 = new Vec3(entitySearching.m_20185_(), entitySearching.m_20188_(), entitySearching.m_20189_());
        Vec3 vec31 = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 0.5, (double)targetPos.m_123343_() + 0.5);
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        BlockHitResult clip = entitySearching.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entitySearching));
        return clip.m_6662_() == HitResult.Type.MISS;
    }

    public static boolean hasLineOfSight(Level level, Vec3 searchingPos, Vec3 targetPos) {
        Vec3 vec31 = new Vec3(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
        Vec3 vec3 = new Vec3(searchingPos.f_82479_, searchingPos.f_82480_, searchingPos.f_82481_);
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        BlockHitResult clip = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return clip.m_6662_() == HitResult.Type.MISS;
    }

    public static float visibleDistance(Level level, Vec3 searchingPos, Vec3 targetPos) {
        Vec3 vec31 = new Vec3(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_);
        Vec3 vec3 = new Vec3(searchingPos.f_82479_, searchingPos.f_82480_, searchingPos.f_82481_);
        if (vec31.m_82554_(vec3) > 128.0) {
            return 128.0f;
        }
        BlockHitResult clip = level.m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        return PositionUtils.distanceTo(clip.m_82450_(), searchingPos);
    }

    public static float distanceTo(Entity mob, BlockPos pos) {
        float f = (float)(mob.m_20185_() - (double)pos.m_123341_());
        float f1 = (float)(mob.m_20186_() - (double)pos.m_123342_());
        float f2 = (float)(mob.m_20189_() - (double)pos.m_123343_());
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceTo(Entity mob, Vec3 pos) {
        float f = (float)(mob.m_20185_() - pos.f_82479_);
        float f1 = (float)(mob.m_20186_() - pos.f_82480_);
        float f2 = (float)(mob.m_20189_() - pos.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceTo(Vec3 posA, Vec3 posB) {
        float f = (float)(posA.f_82479_ - posB.f_82479_);
        float f1 = (float)(posA.f_82480_ - posB.f_82480_);
        float f2 = (float)(posA.f_82481_ - posB.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float horizontalDistanceTo(Vec3 posA, Vec3 posB) {
        float f = (float)(posA.f_82479_ - posB.f_82479_);
        float f1 = 0.0f;
        float f2 = (float)(posA.f_82481_ - posB.f_82481_);
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceTo(BlockPos posA, BlockPos posB) {
        float f = posA.m_123341_() - posB.m_123341_();
        float f1 = posA.m_123342_() - posB.m_123342_();
        float f2 = posA.m_123343_() - posB.m_123343_();
        return Mth.m_14116_((float)(f * f + f1 * f1 + f2 * f2));
    }

    public static float distanceTo(Vec2 posA, Vec2 posB) {
        float f = posA.f_82470_ - posB.f_82470_;
        float f1 = posA.f_82471_ - posB.f_82471_;
        return Mth.m_14116_((float)(f * f + f1 * f1));
    }

    public static boolean isBlockCollidable(Level level, BlockPos pos) {
        return !level.m_8055_(pos).m_60795_() && !level.m_8055_(pos).m_60812_((BlockGetter)level, pos).m_83281_();
    }

    public static boolean isBlockCollidable(Level level, Vec3 pos) {
        return PositionUtils.isBlockCollidable(level, BlockPos.m_274446_((Position)pos));
    }

    public static Vec3 getOffsetPos(Entity entity, double offsetX, double offsetY, double offsetZ, float rotationX, float rotationY) {
        Vec3 Vec32 = new Vec3(offsetZ, offsetY, offsetX).m_82535_((float)Math.toRadians(rotationX)).m_82524_(-rotationY * ((float)Math.PI / 180) - 1.5707964f);
        return entity.m_20182_().m_82520_(Vec32.f_82479_, Vec32.f_82480_, Vec32.f_82481_);
    }

    public static Vec3 getOffsetPos(Vec3 pos, double offsetX, double offsetY, double offsetZ, float rotationX, float rotationY) {
        Vec3 Vec32 = new Vec3(offsetZ, offsetY, offsetX).m_82535_((float)Math.toRadians(rotationX)).m_82524_(-rotationY * ((float)Math.PI / 180) - 1.5707964f);
        return pos.m_82520_(Vec32.f_82479_, Vec32.f_82480_, Vec32.f_82481_);
    }

    public static Comparator<BlockPos> distanceComparator(BlockPos pos) {
        return (a, b) -> (int)PositionUtils.distanceTo(pos, a) - (int)PositionUtils.distanceTo(pos, b);
    }

    public static void moveToGroundHeight(Entity entity, boolean discardIfOutOfBounds) {
        BlockPos blockpos = new BlockPos((int)entity.m_20185_(), entity.m_9236_().m_151558_(), (int)entity.m_20189_());
        boolean flag = false;
        double d0 = 0.0;
        int i = 0;
        do {
            blockpos = entity.m_20183_().m_7918_(0, i, 0);
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = entity.m_9236_().m_8055_(blockpos1);
            if (blockstate.m_60783_((BlockGetter)entity.m_9236_(), blockpos1, Direction.UP) && (entity.m_9236_().m_46859_(blockpos) || entity.m_9236_().m_8055_(blockpos).m_60812_((BlockGetter)entity.m_9236_(), blockpos).m_83281_())) {
                BlockState blockstate1;
                VoxelShape voxelshape;
                if (!entity.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate1 = entity.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)entity.m_9236_(), blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            }
            blockpos = entity.m_20183_().m_7918_(0, -i, 0);
            BlockPos blockpos2 = blockpos.m_7495_();
            BlockState blockstate1 = entity.m_9236_().m_8055_(blockpos2);
            if (blockstate1.m_60783_((BlockGetter)entity.m_9236_(), blockpos2, Direction.UP) && (entity.m_9236_().m_46859_(blockpos) || entity.m_9236_().m_8055_(blockpos).m_60812_((BlockGetter)entity.m_9236_(), blockpos).m_83281_())) {
                BlockState blockstate11;
                VoxelShape voxelshape;
                if (!entity.m_9236_().m_46859_(blockpos) && !(voxelshape = (blockstate11 = entity.m_9236_().m_8055_(blockpos)).m_60812_((BlockGetter)entity.m_9236_(), blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            }
            if (blockpos.m_123342_() > entity.m_9236_().m_151558_() || blockpos.m_123342_() < entity.m_9236_().m_141937_()) {
                if (discardIfOutOfBounds) {
                    entity.m_146870_();
                }
                blockpos = entity.m_20183_();
                flag = true;
                break;
            }
            ++i;
        } while (!flag);
        if (flag) {
            entity.m_6027_(entity.m_20185_(), (double)blockpos.m_123342_() + d0, entity.m_20189_());
        }
    }

    public static BlockPos moveToGroundHeight(Level level, BlockPos pos, int maxDistance) {
        BlockPos blockpos = new BlockPos(pos.m_123341_(), level.m_151558_(), pos.m_123343_());
        boolean flag = false;
        int i = 0;
        do {
            BlockPos blockpos1;
            BlockState blockstate;
            if ((blockstate = level.m_8055_(blockpos1 = (blockpos = pos.m_7918_(0, i, 0)).m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP) && (level.m_46859_(blockpos) || level.m_8055_(blockpos).m_60812_((BlockGetter)level, blockpos).m_83281_())) {
                flag = true;
                break;
            }
            blockpos = pos.m_7918_(0, -i, 0);
            BlockPos blockpos2 = blockpos.m_7495_();
            BlockState blockstate1 = level.m_8055_(blockpos2);
            if (blockstate1.m_60783_((BlockGetter)level, blockpos2, Direction.UP) && (level.m_46859_(blockpos) || level.m_8055_(blockpos).m_60812_((BlockGetter)level, blockpos).m_83281_())) {
                flag = true;
                break;
            }
            if (blockpos.m_123342_() > level.m_151558_() || blockpos.m_123342_() < level.m_141937_() || i > maxDistance) {
                return null;
            }
            ++i;
        } while (!flag);
        return blockpos;
    }

    public static float getLegHeightOffset(LivingEntity entity, Vec3 footPos, int maxSearchRange) {
        BlockPos blockpos = BlockPos.m_274446_((Position)footPos);
        boolean setCurrentHeight = false;
        float currentHeight = -maxSearchRange;
        int foundBlocks = 0;
        for (int i = -maxSearchRange; i < maxSearchRange; ++i) {
            BlockPos offsetPos = blockpos.m_7918_(0, i - 1, 0);
            if ((float)Mth.m_14040_((int)i) < Mth.m_14154_((float)currentHeight) && !entity.m_9236_().m_46859_(offsetPos) && !entity.m_9236_().m_8055_(offsetPos).m_60812_((BlockGetter)entity.m_9236_(), offsetPos).m_83281_() && (entity.m_9236_().m_46859_(offsetPos.m_7494_()) || entity.m_9236_().m_8055_(offsetPos.m_7494_()).m_60812_((BlockGetter)entity.m_9236_(), offsetPos.m_7494_()).m_83281_())) {
                currentHeight = (float)i + (float)entity.m_9236_().m_8055_(offsetPos).m_60812_((BlockGetter)entity.m_9236_(), offsetPos).m_83297_(Direction.Axis.Y) - 1.0f;
                setCurrentHeight = true;
            }
            if (entity.m_9236_().m_46859_(offsetPos) || entity.m_9236_().m_8055_(offsetPos).m_60812_((BlockGetter)entity.m_9236_(), offsetPos).m_83281_()) continue;
            ++foundBlocks;
        }
        if (!setCurrentHeight) {
            currentHeight = foundBlocks > maxSearchRange ? (float)maxSearchRange : (float)(-maxSearchRange);
        }
        return (float)((double)currentHeight - (entity.m_20186_() - (double)entity.m_146904_()));
    }

    public static boolean containsWater(Level level, AABB aabb) {
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            if (!level.m_6425_(blockpos).m_205070_(FluidTags.f_13131_)) continue;
            return true;
        }
        return false;
    }
}

