/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.rendering.layers;

import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import com.alexander.witherreincarnated.utils.RenderingUtils;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class PossessedLayer<T extends LivingEntity>
extends RenderLayer<T, EntityModel<T>> {
    public final RenderLayerParent<T, EntityModel<T>> renderer;
    public static final ResourceLocation FLASH_LOCATION = new ResourceLocation("witherreincarnated", "textures/entities/possession.png");

    public PossessedLayer(RenderLayerParent<T, EntityModel<T>> renderer) {
        super(renderer);
        this.renderer = renderer;
    }

    public void render(PoseStack stack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
        entity.getCapability(PossessedCapabilityProvider.CAP).ifPresent(cap -> {
            if (cap.isPossessed() || cap.possessionCooldown > 0 && cap.possessionCooldown < 10) {
                boolean flag;
                ResourceLocation originalLocation = this.renderer.m_5478_((Entity)entity);
                ResourceLocation possessedLocation = new ResourceLocation(originalLocation.m_135827_(), originalLocation.m_135815_().substring(0, originalLocation.m_135815_().indexOf(".")) + "_possessed_witherreincarnated" + originalLocation.m_135815_().substring(originalLocation.m_135815_().indexOf(".")));
                boolean bl = flag = Minecraft.m_91087_().f_90987_.m_118506_(possessedLocation) != MissingTextureAtlasSprite.m_118080_();
                if (cap.isPossessed()) {
                    VertexConsumer vertexconsumer;
                    if (flag) {
                        vertexconsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)possessedLocation));
                        this.m_117386_().m_7695_(stack, vertexconsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                    }
                    if (cap.possessedFor < 10) {
                        vertexconsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)FLASH_LOCATION));
                        float alpha = 1.0f - (float)cap.possessedFor / 10.0f;
                        this.m_117386_().m_7695_(stack, vertexconsumer, packedLight, OverlayTexture.f_118083_, alpha, alpha, alpha, alpha);
                        RenderingUtils.renderLightning(stack, buffer, entity.m_19879_() * entity.f_19797_, -entity.f_20883_, null, new Vector3f(0.025f, -0.025f, 0.025f));
                    }
                } else if (flag && cap.possessionCooldown > 0 && cap.possessionCooldown < 10) {
                    VertexConsumer vertexconsumer = buffer.m_6299_(RenderType.m_110488_((ResourceLocation)possessedLocation));
                    float alpha = 1.0f - (float)cap.possessionCooldown / 10.0f;
                    this.m_117386_().m_7695_(stack, vertexconsumer, packedLight, OverlayTexture.f_118083_, alpha, alpha, alpha, alpha);
                }
            }
        });
    }
}

