/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.network;

import com.alexander.witherreincarnated.events.HandleAnimationsEvent;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundWitherStartAnimationPacket {
    private final int witherId;
    private final int animation;

    public ClientboundWitherStartAnimationPacket(int witherId, int animation) {
        this.witherId = witherId;
        this.animation = animation;
    }

    public ClientboundWitherStartAnimationPacket(FriendlyByteBuf buf) {
        this.witherId = buf.readInt();
        this.animation = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.witherId);
        buf.writeInt(this.animation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            WitherBoss wither;
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.witherId);
            if (entity != null && entity instanceof WitherBoss && HandleAnimationsEvent.witherAnimations.containsKey(wither = (WitherBoss)entity)) {
                if (this.animation == 0) {
                    HandleAnimationsEvent.witherAnimations.get((Object)wither).chargeAnimationState.m_216977_(wither.f_19797_);
                } else if (this.animation == 1) {
                    HandleAnimationsEvent.witherAnimations.get((Object)wither).stunTick = 80;
                } else if (this.animation == 2) {
                    HandleAnimationsEvent.witherAnimations.get((Object)wither).barrageAnimationState.m_216977_(wither.f_19797_);
                    HandleAnimationsEvent.witherAnimations.get((Object)wither).barrageTick = 150;
                }
            }
        });
        return true;
    }
}

