/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.network;

import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundUpdatePossessedMobPacket {
    private final int mobId;
    private final int possessedById;
    private final int possessionTime;
    private final int possessedFor;
    private final int possessionCooldown;

    public ClientboundUpdatePossessedMobPacket(int mobId, int possessedById, int possessionTime, int possessedFor, int possessionCooldown) {
        this.mobId = mobId;
        this.possessedById = possessedById;
        this.possessionTime = possessionTime;
        this.possessedFor = possessedFor;
        this.possessionCooldown = possessionCooldown;
    }

    public ClientboundUpdatePossessedMobPacket(FriendlyByteBuf buf) {
        this.mobId = buf.readInt();
        this.possessedById = buf.readInt();
        this.possessionTime = buf.readInt();
        this.possessedFor = buf.readInt();
        this.possessionCooldown = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.mobId);
        buf.writeInt(this.possessedById);
        buf.writeInt(this.possessionTime);
        buf.writeInt(this.possessedFor);
        buf.writeInt(this.possessionCooldown);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.mobId);
            Entity possessedBy = Minecraft.m_91087_().f_91073_.m_6815_(this.possessedById);
            if (entity != null) {
                entity.getCapability(PossessedCapabilityProvider.CAP).ifPresent(cap -> {
                    cap.possessionTime = this.possessionTime;
                    cap.possessedFor = this.possessedFor;
                    cap.possessionCooldown = this.possessionCooldown;
                    if (this.possessedById != 0 && possessedBy != null && possessedBy instanceof LivingEntity) {
                        LivingEntity livingPossessor;
                        cap.possessedBy = livingPossessor = (LivingEntity)possessedBy;
                    }
                });
            }
        });
        return true;
    }
}

