/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.mixin;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={WitherSkull.class})
public abstract class WitherSkullMixin
extends AbstractHurtingProjectile {
    @Shadow
    public abstract boolean m_37635_();

    protected WitherSkullMixin(EntityType<? extends AbstractHurtingProjectile> p_36833_, Level p_36834_) {
        super(p_36833_, p_36834_);
    }

    @Inject(method={"onHit"}, at={@At(value="TAIL")}, cancellable=true)
    private void witherreincarnated_onExplosion(HitResult result, CallbackInfo callback) {
        if (!this.m_9236_().f_46443_) {
            for (LivingEntity entity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(2.0))) {
                if (entity.f_20916_ <= 0) continue;
                entity.m_147207_(new MobEffectInstance(MobEffects.f_19615_, 100, 1), this.m_150173_());
            }
        }
    }

    @ModifyArg(method={"onHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;"), index=4)
    private float witherreincarnated_increaseSkullExplosionSize(float o) {
        return this.m_37635_() ? ((Double)WRCommonConfig.dangerous_wither_skull_explosion_size.get()).floatValue() : ((Double)WRCommonConfig.wither_skull_explosion_size.get()).floatValue();
    }

    @ModifyArg(method={"onHit"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;explode(Lnet/minecraft/world/entity/Entity;DDDFZLnet/minecraft/world/level/Level$ExplosionInteraction;)Lnet/minecraft/world/level/Explosion;"), index=5)
    private boolean witherreincarnated_makeSkullsProduceFire(boolean o) {
        return !(!this.m_37635_() && !this.f_19796_.m_188499_() || !ForgeEventFactory.getMobGriefingEvent((Level)this.m_150173_().m_9236_(), (Entity)this.m_150173_()) && (Boolean)WRCommonConfig.wither_fire_ignores_mob_griefing.get() == false || (Boolean)WRCommonConfig.wither_attacks_produce_fire.get() == false) ? true : o;
    }

    @ModifyArg(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;heal(F)V"), index=0)
    private float witherreincarnated_skullsDontLifesteal(float o) {
        return 0.0f;
    }

    @ModifyArg(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal=0), index=1)
    private float witherreincarnated_modifySkullDamage(float o, @Local LocalRef<EntityHitResult> p_37626_) {
        return ((EntityHitResult)p_37626_.get()).m_82443_() instanceof WitherBoss ? ((Double)WRCommonConfig.dangerous_wither_skull_deflected_damage.get()).floatValue() : (this.m_37635_() ? ((Double)WRCommonConfig.dangerous_wither_skull_damage.get()).floatValue() : ((Double)WRCommonConfig.wither_skull_damage.get()).floatValue());
    }

    @ModifyArg(method={"onHitEntity"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z", ordinal=1), index=1)
    private float witherreincarnated_modifySkullDamage2(float o, @Local LocalRef<EntityHitResult> p_37626_) {
        return ((EntityHitResult)p_37626_.get()).m_82443_() instanceof WitherBoss ? ((Double)WRCommonConfig.dangerous_wither_skull_deflected_damage.get()).floatValue() : (this.m_37635_() ? ((Double)WRCommonConfig.dangerous_wither_skull_damage.get()).floatValue() : ((Double)WRCommonConfig.wither_skull_damage.get()).floatValue());
    }

    @Inject(method={"isPickable"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_makeDangerousSkullsPickable(CallbackInfoReturnable<Boolean> callback) {
        if (this.m_37635_()) {
            callback.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getInertia"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_increaseDangerousSkullSpeed(CallbackInfoReturnable<Float> callback) {
        if (this.m_37635_()) {
            callback.setReturnValue((Object)Float.valueOf(0.89f));
        }
    }

    @Inject(method={"hurt"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_makeDangerousSkullsHittable(DamageSource p_37616_, float p_37617_, CallbackInfoReturnable<Boolean> callback) {
        if (this.m_37635_() && !this.m_6673_(p_37616_)) {
            this.m_5834_();
            Entity entity = p_37616_.m_7639_();
            if (entity != null && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (!this.m_9236_().f_46443_) {
                    Vec3 vec3 = entity.m_20154_();
                    WitherSkull witherskull = new WitherSkull(this.m_9236_(), living, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                    witherskull.m_5602_((Entity)living);
                    witherskull.m_37629_(true);
                    witherskull.m_20343_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    this.m_9236_().m_7967_((Entity)witherskull);
                    this.m_5496_((SoundEvent)SoundEventInit.WITHER_DEFLECT_SKULL.get(), 1.0f, MiscUtils.randomSoundPitch());
                    this.m_146870_();
                }
                callback.setReturnValue((Object)true);
            }
        }
    }
}

