/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.mixin;

import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapability;
import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import com.alexander.witherreincarnated.events.HandleAnimationsEvent;
import com.alexander.witherreincarnated.events.HandlePossessedMobsEvent;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Shadow
    public int f_20919_;
    @Shadow
    public float f_20883_;
    @Shadow
    @Nullable
    protected Player f_20888_;
    @Nullable
    private Player unlimitedLastHurtByPlayer = null;

    @Shadow
    public abstract void m_5618_(float var1);

    public LivingEntityMixin(EntityType<?> p_19870_, Level p_19871_) {
        super(p_19870_, p_19871_);
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void witherreincarnated_trackUnlimitedLastHurtByPlayer(CallbackInfo callback) {
        if (this instanceof WitherBoss) {
            if (this.f_20888_ != null) {
                this.unlimitedLastHurtByPlayer = this.f_20888_;
            }
            if (this.unlimitedLastHurtByPlayer != null && this.unlimitedLastHurtByPlayer.m_213877_()) {
                this.unlimitedLastHurtByPlayer = null;
            }
        }
    }

    @Inject(method={"tickDeath"}, at={@At(value="HEAD")}, cancellable=true)
    private void witherreincarnated_performWitherDeathAnimation(CallbackInfo callback) {
        LivingEntityMixin livingEntityMixin = this;
        if (livingEntityMixin instanceof WitherBoss) {
            WitherBoss wither = (WitherBoss)livingEntityMixin;
            ++this.f_20919_;
            if (this.f_20919_ >= 200 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
                ItemEntity itementity = this.m_19998_((ItemLike)Items.f_42686_);
                if (itementity != null) {
                    itementity.m_32064_();
                    itementity.m_146915_(true);
                }
                this.m_142687_(Entity.RemovalReason.KILLED);
            }
            if (this.m_9236_().m_5776_()) {
                HandleAnimationsEvent.witherAnimations.get((Object)((Object)this)).deathAnimationState.m_216982_(this.f_19797_);
                if (this.f_20919_ >= 90) {
                    for (int i = 0; i < 50; ++i) {
                        this.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123746_, true, this.m_20185_(), this.m_20186_() + (double)(this.m_20206_() / 2.0f), this.m_20189_(), this.f_19796_.m_188583_() * 1.5, this.f_19796_.m_188583_() * 1.5, this.f_19796_.m_188583_() * 1.5);
                    }
                }
            } else if (this.f_20919_ >= 60) {
                this.m_5618_(this.f_20883_);
                this.m_146922_(this.f_20883_);
                if (this.f_20919_ >= 90) {
                    if (this.f_20919_ == 90) {
                        this.m_5496_((SoundEvent)SoundEventInit.WITHER_DEATH.get(), 50.0f, 1.0f);
                    }
                    this.m_20334_(0.0, 0.0, 0.0);
                    boolean flag = this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_);
                    int i = 1000;
                    if (this.f_20919_ % 5 == 0 && flag) {
                        int award = ForgeEventFactory.getExperienceDrop((LivingEntity)wither, (Player)this.unlimitedLastHurtByPlayer, (int)Mth.m_14143_((float)((float)i / 110.0f * 5.0f)));
                        ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.m_9236_()), (Vec3)this.m_20182_(), (int)award);
                    }
                } else {
                    this.m_20334_(0.0, 0.25, 0.0);
                }
            } else {
                this.m_20256_(PositionUtils.getOffsetPos(Vec3.f_82478_, 0.0, 1.0, 0.8, 0.0f, this.f_20883_));
                float rot = this.f_20883_ + 10.0f;
                this.m_5618_(rot);
                this.m_146922_(rot);
            }
            this.m_5616_(this.f_20883_);
            callback.cancel();
        }
    }

    @Inject(method={"canAttack"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_setPossessionCanAttack(LivingEntity target, CallbackInfoReturnable<Boolean> callback) {
        if (this.getCapability(PossessedCapabilityProvider.CAP).isPresent() && ((PossessedCapability)this.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessionCooldown > 0 && ((PossessedCapability)this.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessionCooldown < 200) {
            callback.setReturnValue((Object)false);
        } else if (HandlePossessedMobsEvent.POSSESSED.test((Entity)target) && ((PossessedCapability)target.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy == (LivingEntity)this) {
            callback.setReturnValue((Object)false);
        } else if (HandlePossessedMobsEvent.POSSESSED.test(this) && ((PossessedCapability)this.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy == target) {
            callback.setReturnValue((Object)false);
        } else if (HandlePossessedMobsEvent.POSSESSED.test(this) && HandlePossessedMobsEvent.POSSESSED.test((Entity)target) && ((PossessedCapability)target.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy == ((PossessedCapability)this.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy) {
            callback.setReturnValue((Object)false);
        }
    }

    @Inject(method={"getSoundVolume"}, at={@At(value="RETURN")}, cancellable=true)
    private void witherreincarnated_increaseWitherSoundVolume(CallbackInfoReturnable<Float> callback) {
        if (this instanceof WitherBoss) {
            callback.setReturnValue((Object)Float.valueOf(10.0f));
        }
    }

    @Inject(method={"createWitherRose"}, cancellable=true, at={@At(value="HEAD")})
    private void witherreincarnated_overrideCreateWitherRose(@Nullable LivingEntity p_21269_, CallbackInfo callback) {
        if (!this.m_9236_().f_46443_) {
            boolean flag = false;
            if (p_21269_ instanceof WitherBoss || p_21269_ == null && MiscUtils.isEntityValid((Entity)this.m_9236_().m_45963_(WitherBoss.class, TargetingConditions.m_148353_().m_26893_().m_148355_(), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20191_().m_82400_(50.0)))) {
                if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)p_21269_)) {
                    int placed = 0;
                    for (int i = 0; i < 20; ++i) {
                        BlockPos blockpos = this.m_20183_().m_7918_((int)this.f_19796_.m_188583_() * 5, (int)this.f_19796_.m_188583_() * 2, (int)this.f_19796_.m_188583_() * 5);
                        BlockState blockstate = Blocks.f_50070_.m_49966_();
                        if (this.m_9236_().m_46859_(blockpos) && blockstate.m_60710_((LevelReader)this.m_9236_(), blockpos)) {
                            this.m_9236_().m_7731_(blockpos, blockstate, 3);
                            flag = true;
                            ++placed;
                        }
                        if (placed >= 5) break;
                    }
                }
                if (!flag) {
                    ItemEntity itementity = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack((ItemLike)Items.f_41951_));
                    this.m_9236_().m_7967_((Entity)itementity);
                }
            }
        }
        callback.cancel();
    }
}

