/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.config.WRClientConfig;
import com.alexander.witherreincarnated.events.CameraShakeEvents;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.rendering.BetterWitherRenderer;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Matrix4f;

@Mod.EventBusSubscriber(modid="witherreincarnated", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ParticleSpawnersEvent {
    public static NonNullList<SmokeColumn> smokeColumns = NonNullList.m_122779_();
    public static NonNullList<DistantFire> distantFire = NonNullList.m_122779_();
    private static RandomSource random = RandomSource.m_216327_();

    @SubscribeEvent
    public static void removeParticles(TickEvent.ClientTickEvent event) {
        if (Minecraft.m_91087_().f_91073_ == null) {
            smokeColumns.clear();
            distantFire.clear();
        }
    }

    @SubscribeEvent
    public static void updateParticles(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.level.f_46443_) {
            ArrayList columnsToRemove = Lists.newArrayList();
            for (SmokeColumn column : smokeColumns) {
                column.tick(event.level);
                if (!column.removed) continue;
                columnsToRemove.add(column);
            }
            smokeColumns.removeAll((Collection)columnsToRemove);
            ArrayList distantFireToRemove = Lists.newArrayList();
            for (DistantFire distantFire : ParticleSpawnersEvent.distantFire) {
                distantFire.tick(event.level);
                if (!distantFire.removed) continue;
                distantFireToRemove.add(distantFire);
            }
            distantFire.removeAll((Collection)distantFireToRemove);
        }
    }

    @SubscribeEvent
    public static void renderGlows(RenderLevelStageEvent event) {
        if (event.getStage().equals(RenderLevelStageEvent.Stage.AFTER_PARTICLES) && Minecraft.m_91087_().f_91066_.m_232060_().m_231551_() == GraphicsStatus.FABULOUS) {
            ParticleSpawnersEvent.renderGlows(event.getPoseStack(), Minecraft.m_91087_().f_91073_);
        }
    }

    public static void renderGlows(PoseStack stack, ClientLevel level) {
        MultiBufferSource.BufferSource buffer = Minecraft.m_91087_().m_91269_().m_110104_();
        VertexConsumer builder = buffer.m_6299_(RenderType.m_110502_());
        Color fireColour = new Color((Integer)WRClientConfig.distant_fire_colour.get());
        for (DistantFire fire : distantFire) {
            if (!(fire.alpha > 0.0f)) continue;
            Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
            Vec3 negativeCameraPos = new Vec3(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
            stack.m_85836_();
            Vec3 pos = negativeCameraPos.m_82549_(fire.pos);
            stack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            stack.m_252781_(Axis.f_252436_.m_252977_(-PositionUtils.rotationToFace((Vec3)fire.pos, (Vec3)cameraPos).f_82471_ + 180.0f));
            stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            stack.m_85841_(1.0f, 1.0f, 0.25f);
            Matrix4f matrix = stack.m_85850_().m_252922_();
            float size = 100.0f;
            float resolution = ((Double)WRClientConfig.distant_fire_detail.get()).floatValue();
            int i = 0;
            while ((float)i < 360.0f * resolution) {
                Vec3 pos1 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)i / resolution);
                Vec3 pos2 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 1) / resolution);
                Vec3 pos3 = PositionUtils.getOffsetPos(Vec3.f_82478_, (double)size, 0.0, 0.0, 0.0f, (float)(i + 2) / resolution);
                builder.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_85950_((float)fireColour.getRed() / 255.0f, (float)fireColour.getGreen() / 255.0f, (float)fireColour.getBlue() / 255.0f, fire.alpha).m_5752_();
                builder.m_252986_(matrix, (float)pos1.f_82479_, (float)pos1.f_82480_, (float)pos1.f_82481_).m_85950_((float)fireColour.getRed() / 255.0f, (float)fireColour.getGreen() / 255.0f, (float)fireColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos2.f_82479_, (float)pos2.f_82480_, (float)pos2.f_82481_).m_85950_((float)fireColour.getRed() / 255.0f, (float)fireColour.getGreen() / 255.0f, (float)fireColour.getBlue() / 255.0f, 0.0f).m_5752_();
                builder.m_252986_(matrix, (float)pos3.f_82479_, (float)pos3.f_82480_, (float)pos3.f_82481_).m_85950_((float)fireColour.getRed() / 255.0f, (float)fireColour.getGreen() / 255.0f, (float)fireColour.getBlue() / 255.0f, 0.0f).m_5752_();
                ++i;
            }
            stack.m_85849_();
        }
        for (Entity entity : level.m_104735_()) {
            if (!(entity instanceof WitherBoss)) continue;
            WitherBoss wither = (WitherBoss)entity;
            BetterWitherRenderer.tryRenderDeathGlow(wither, stack, (MultiBufferSource)buffer);
            BetterWitherRenderer.tryRenderShine(wither, stack, (MultiBufferSource)buffer);
        }
        buffer.m_109911_();
    }

    public static void handleWitherSkullBlast(BlockPos pos) {
        if (PositionUtils.distanceTo((Entity)Minecraft.m_91087_().f_91074_, pos) >= 16.0f && random.m_188503_(2) == 0) {
            Minecraft.m_91087_().f_91073_.m_245747_(pos, (SoundEvent)SoundEventInit.WITHER_PROJECTILE_EXPLOSION.get(), SoundSource.HOSTILE, 15.0f, 0.9f + (float)(random.m_188583_() * (double)0.1f), true);
        }
        if ((Integer)WRClientConfig.max_smoke_columns.get() > 0) {
            smokeColumns.add((Object)new SmokeColumn(pos));
            if (smokeColumns.size() > (Integer)WRClientConfig.max_smoke_columns.get()) {
                smokeColumns.remove(0);
            }
        }
        if ((Integer)WRClientConfig.max_distant_fire.get() > 0) {
            distantFire.add((Object)new DistantFire(pos.m_252807_()));
            if (distantFire.size() > (Integer)WRClientConfig.max_distant_fire.get()) {
                distantFire.remove(0);
            }
        }
        if (Minecraft.m_91087_().f_91073_.m_45976_(WitherSkull.class, AABB.m_165882_((Vec3)pos.m_252807_(), (double)100.0, (double)100.0, (double)100.0)).size() < 10) {
            CameraShakeEvents.addCameraShake((Level)Minecraft.m_91087_().f_91073_, 40, 0.25f, pos, 10);
            CameraShakeEvents.addCameraShake((Level)Minecraft.m_91087_().f_91073_, 20, 0.05f, pos, 100);
        }
    }

    public static class SmokeColumn {
        public final BlockPos pos;
        public int time;
        public boolean removed;
        public Level level;

        public SmokeColumn(BlockPos pos) {
            this.pos = pos;
            this.time = 3600;
            this.level = Minecraft.m_91087_().f_91073_;
        }

        public void tick(Level level) {
            if (!this.removed) {
                if (this.time > 0 && this.level == level) {
                    --this.time;
                    Vec3 vec3 = this.pos.m_252807_();
                    if (level.f_46441_.m_188503_(100) == 0) {
                        level.m_6485_((ParticleOptions)ParticleTypeInit.HUGE_SMOKE.get(), true, vec3.f_82479_ + level.f_46441_.m_188583_() * 5.0, vec3.f_82480_, vec3.f_82481_ + level.f_46441_.m_188583_() * 5.0, 0.0, 0.125, 0.0);
                    }
                    if (((Boolean)WRClientConfig.falling_ash_near_smoke_columns.get()).booleanValue()) {
                        for (int i = 0; i < 10; ++i) {
                            level.m_6485_((ParticleOptions)ParticleTypes.f_123783_, true, vec3.f_82479_ + level.f_46441_.m_188583_() * 20.0, vec3.f_82480_ + (double)(level.f_46441_.m_188501_() * 10.0f), vec3.f_82481_ + level.f_46441_.m_188583_() * 20.0, 0.0, 0.1, 0.0);
                        }
                    }
                } else {
                    this.removed = true;
                }
            }
        }
    }

    public static class DistantFire {
        public final Vec3 pos;
        public int time;
        public boolean removed;
        public float alpha;
        public Level level;

        public DistantFire(Vec3 pos) {
            this.pos = pos;
            this.time = 2400;
            this.level = Minecraft.m_91087_().f_91073_;
        }

        public void tick(Level level) {
            if (!this.removed) {
                if (this.time > 0 && this.level == level) {
                    Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
                    --this.time;
                    this.alpha = (this.time > 2300 ? (float)(1200 - this.time) / 100.0f : (float)this.time / 2300.0f) * (1.0f + (float)(level.f_46441_.m_188583_() * (double)0.05f)) * ((Double)WRClientConfig.distant_fire_opacity.get()).floatValue();
                    this.alpha *= Mth.m_14036_((float)((PositionUtils.distanceTo(new Vec3(this.pos.f_82479_, 0.0, this.pos.f_82481_), new Vec3(cameraPos.f_82479_, 0.0, cameraPos.f_82481_)) - 50.0f) / 50.0f), (float)0.0f, (float)1.0f);
                } else {
                    this.removed = true;
                }
            }
        }
    }
}

