/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.config.WRClientConfig;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="witherreincarnated", value={Dist.CLIENT})
public class HandleWitherMusicEvent {
    public static int endTime;
    public static float volume;
    public static Map<Integer, WitherMusic> musicForWithers;
    private static WitherMusic toPlayTemporaryMusic;

    @SubscribeEvent
    public static void tickMusic(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && (Double)WRClientConfig.music_volume.get() > 0.0) {
            if (Minecraft.m_91087_().f_91073_ != null) {
                musicForWithers.clear();
                for (Entity entity : Minecraft.m_91087_().f_91073_.m_104735_()) {
                    if (!(entity instanceof WitherBoss)) continue;
                    WitherBoss wither = (WitherBoss)entity;
                    WitherMusic forWither = null;
                    forWither = wither.m_31502_() > 0 ? WitherMusic.WITHER_INTRO : (wither.f_20919_ > 0 ? WitherMusic.WITHER_OUTRO : (wither.m_7090_() || (Boolean)WRClientConfig.only_play_one_music_track.get() != false ? WitherMusic.WITHER_FINALE : WitherMusic.WITHER));
                    musicForWithers.put(wither.m_19879_(), forWither);
                }
                WitherMusic toPlay = HandleWitherMusicEvent.toPlay();
                if (toPlay != null) {
                    volume = Mth.m_14179_((float)0.05f, (float)volume, (float)1.0f);
                    if (toPlay == WitherMusic.WITHER || toPlay == WitherMusic.WITHER_FINALE) {
                        endTime = 1200;
                    }
                } else if (endTime > 0) {
                    volume = Mth.m_14179_((float)((float)endTime / 1200.0f), (float)0.0f, (float)1.0f);
                    --endTime;
                } else {
                    WitherMusic.WITHER_INTRO.stopPlayingIfPresent();
                    WitherMusic.WITHER.stopPlayingIfPresent();
                    WitherMusic.WITHER_FINALE.stopPlayingIfPresent();
                }
            } else {
                endTime = 0;
            }
        }
    }

    public static WitherMusic toPlay() {
        toPlayTemporaryMusic = null;
        musicForWithers.forEach((wither, witherMusic) -> {
            if (witherMusic != null && (toPlayTemporaryMusic == null || witherMusic.priority > HandleWitherMusicEvent.toPlayTemporaryMusic.priority)) {
                toPlayTemporaryMusic = witherMusic;
            }
        });
        return toPlayTemporaryMusic;
    }

    static {
        volume = 1.0f;
        musicForWithers = Maps.newHashMap();
        toPlayTemporaryMusic = null;
    }

    public static enum WitherMusic {
        WITHER_FINALE(3, SoundEventInit.MUSIC_WITHER_FINALE.getHolder()),
        WITHER(2, SoundEventInit.MUSIC_WITHER.getHolder()),
        WITHER_INTRO(1, SoundEventInit.MUSIC_WITHER_INTRO.getHolder()),
        WITHER_OUTRO(0, SoundEventInit.MUSIC_WITHER_OUTRO.getHolder());

        public final int priority;
        public final Optional<Holder<SoundEvent>> music;

        private WitherMusic(int priority, Optional<Holder<SoundEvent>> music) {
            this.priority = priority;
            this.music = music;
        }

        public void stopPlayingIfPresent() {
            if (this.getMusic() != null) {
                Minecraft.m_91087_().m_91397_().m_278151_(this.getMusic());
            }
        }

        public Music getMusic() {
            return this.music.isPresent() ? new Music(this.music.get(), 6000, 12000, true) : null;
        }

        public static WitherMusic bySoundEvent(SoundEvent sound) {
            for (WitherMusic music : WitherMusic.values()) {
                if (music.getMusic() == null || music.getMusic().m_263193_().get() != sound) continue;
                return music;
            }
            return null;
        }

        public static WitherMusic byLocation(ResourceLocation location) {
            for (WitherMusic music : WitherMusic.values()) {
                if (music.getMusic() == null || ((SoundEvent)music.getMusic().m_263193_().get()).m_11660_() != location) continue;
                return music;
            }
            return null;
        }
    }
}

