/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.ai.controllers.wither.WitherMoveControl;
import com.alexander.witherreincarnated.ai.goals.AdvancedNearestAttackableTargetGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherBackUpGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherBarrageGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherChargeGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherLaserGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherRandomTravelGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherRangedAttackGoal;
import com.alexander.witherreincarnated.ai.goals.wither.WitherTargetNearestPlayerGoal;
import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapability;
import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.events.HandlePossessedMobsEvent;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.init.TagInit;
import com.alexander.witherreincarnated.network.ClientboundUpdatePossessedMobPacket;
import com.alexander.witherreincarnated.network.Messages;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="witherreincarnated")
public class HandleWitherEvent {
    public static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR_PLAYER_ALLOWING = entity -> entity != null && !entity.m_6095_().m_204039_(TagInit.EntityTypes.WITHER_WONT_ATTACK) && entity.m_6084_() && !HandlePossessedMobsEvent.POSSESSED.test((Entity)entity) && entity.m_5789_() && entity.m_142066_();
    public static final Predicate<LivingEntity> LIVING_ENTITY_SELECTOR = entity -> LIVING_ENTITY_SELECTOR_PLAYER_ALLOWING.test((LivingEntity)entity) && !(entity instanceof Player) && !PositionUtils.containsWater(entity.m_9236_(), entity.m_20191_().m_82400_(1.0));
    public static final List<WitherLifeSteal> lifeSteals = Lists.newArrayList();
    public static boolean stoleHealthThisTick = false;

    @SubscribeEvent
    public static void witherSpawn(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof WitherBoss) {
            final WitherBoss wither = (WitherBoss)entity;
            if (!wither.m_9236_().f_46443_) {
                wither.f_21342_ = new WitherMoveControl((Mob)wither);
                wither.f_21345_.m_262460_(goal -> !(goal instanceof WitherBoss.WitherDoNothingGoal));
                wither.f_21346_.m_262460_(goal -> true);
                wither.f_21345_.m_25352_(1, (Goal)new WitherBarrageGoal(wither));
                wither.f_21345_.m_25352_(2, (Goal)new WitherLaserGoal(wither));
                wither.f_21345_.m_25352_(3, (Goal)new WitherChargeGoal(wither));
                wither.f_21345_.m_25352_(4, (Goal)new WitherBackUpGoal(wither));
                wither.f_21345_.m_25352_(5, (Goal)new WitherRangedAttackGoal(wither, 1.5, 30.0f));
                wither.f_21345_.m_25352_(6, (Goal)new WitherRandomTravelGoal(wither));
                wither.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)wither, Player.class, 8.0f));
                wither.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)wither){

                    public boolean m_8036_() {
                        return wither.m_217043_().m_188501_() < 0.25f;
                    }
                });
                wither.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)wither, new Class[0]){

                    public boolean m_8036_() {
                        return ((WitherBoss)this.f_26135_).m_31502_() <= 0 && (this.f_26135_.m_21223_() <= this.f_26135_.m_21233_() * 0.6666667f || (Boolean)WRCommonConfig.vanilla_wither_phases.get() != false) && super.m_8036_();
                    }
                });
                wither.f_21346_.m_25352_(2, (Goal)new WitherTargetNearestPlayerGoal(wither));
                wither.f_21346_.m_25352_(3, (Goal)new AdvancedNearestAttackableTargetGoal<LivingEntity>((Mob)wither, LivingEntity.class, 0.0, true, false, true, false, LIVING_ENTITY_SELECTOR){

                    public boolean m_8036_() {
                        return ((WitherBoss)this.f_26135_).m_31502_() <= 0 && super.m_8036_();
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void witherTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity;
        if (!event.getEntity().m_9236_().f_46443_ && (livingEntity = event.getEntity()) instanceof WitherBoss) {
            WitherBoss wither = (WitherBoss)livingEntity;
            Level level = wither.m_9236_();
            boolean flag = false;
            for (int i = 0; i < (!wither.m_7090_() || wither.m_31502_() > 0 ? 15 : 5); ++i) {
                if (!PositionUtils.isBlockCollidable(level, wither.m_20183_().m_6625_(i)) && level.m_6425_(wither.m_20183_().m_6625_(i)).m_76178_()) continue;
                flag = true;
                break;
            }
            wither.m_20256_(wither.m_20184_().m_82549_(new Vec3(0.0, flag ? 0.1 : -0.05, 0.0)));
            if (wither.m_31502_() <= 0) {
                for (LivingEntity entity : wither.m_9236_().m_45976_(LivingEntity.class, wither.m_20191_().m_82400_(64.0))) {
                    LightningBolt lightningbolt;
                    ServerPlayer player;
                    if (entity instanceof Mob) {
                        Mob mob = (Mob)entity;
                        if (entity.m_6095_().m_204039_(TagInit.EntityTypes.WITHER_CANT_POSSESS) || !((Boolean)WRCommonConfig.wither_possesses_nearby_undead.get()).booleanValue() || mob == wither || !wither.m_6779_((LivingEntity)mob) || mob.m_6336_() != MobType.f_21641_ || wither.m_217043_().m_188503_(400) != 0 || !wither.m_142582_((Entity)mob) && !wither.m_20191_().m_82377_(50.0, 25.0, 50.0).m_82381_(mob.m_20191_())) continue;
                        mob.getCapability(PossessedCapabilityProvider.CAP).ifPresent(cap -> {
                            if (cap.canBePossessed()) {
                                int possessionDuration;
                                cap.possessionTime = possessionDuration = MiscUtils.randomIntBetween(600, 2400);
                                cap.possessedBy = wither;
                                cap.possessedByUUID = wither.m_20148_();
                                Messages.sendToAllPlayers(new ClientboundUpdatePossessedMobPacket(mob.m_19879_(), cap.possessedBy.m_19879_(), cap.possessionTime, 0, 0), mob.m_9236_());
                                mob.m_9236_().m_245803_((Entity)mob, mob.m_20183_(), (SoundEvent)SoundEventInit.WITHER_POSSESS.get(), SoundSource.HOSTILE, 1.5f, MiscUtils.randomSoundPitch());
                                mob.m_21573_().m_26573_();
                            }
                        });
                        continue;
                    }
                    if (!(entity instanceof ServerPlayer) || !(wither.m_20270_((Entity)(player = (ServerPlayer)entity)) <= 16.0f) || !wither.m_6779_((LivingEntity)player) || !player.m_21255_() || wither.m_217043_().m_188503_(20) != 0 || (lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(wither.m_9236_())) == null) continue;
                    lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_()));
                    lightningbolt.m_20879_(null);
                    wither.m_9236_().m_7967_((Entity)lightningbolt);
                    player.m_36321_();
                    player.m_36335_().m_41524_(player.m_6844_(EquipmentSlot.CHEST).m_41720_(), 400);
                }
            }
        }
    }

    @SubscribeEvent
    public static void levelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.f_46443_ && event.phase == TickEvent.Phase.START) {
            stoleHealthThisTick = false;
            ArrayList toRemove = Lists.newArrayList();
            for (WitherLifeSteal lifeSteal : lifeSteals) {
                lifeSteal.tick();
                if (!lifeSteal.removed) continue;
                toRemove.add(lifeSteal);
            }
            lifeSteals.removeAll(toRemove);
        }
    }

    @SubscribeEvent
    public static void entityHurt(LivingHurtEvent event) {
        if (!(stoleHealthThisTick || HandlePossessedMobsEvent.POSSESSED.test((Entity)event.getEntity()) || event.getEntity() instanceof WitherBoss)) {
            WitherBoss wither = null;
            Entity entity = event.getSource().m_7639_();
            if (entity instanceof WitherBoss) {
                WitherBoss sourceWither;
                wither = sourceWither = (WitherBoss)entity;
            } else if (HandlePossessedMobsEvent.POSSESSED.test(event.getSource().m_7639_()) && ((PossessedCapability)event.getSource().m_7639_().getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy != null && (entity = ((PossessedCapability)event.getSource().m_7639_().getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy) instanceof WitherBoss) {
                WitherBoss possessingWither;
                wither = possessingWither = (WitherBoss)entity;
            }
            if (MiscUtils.isEntityValid((Entity)wither) && wither.m_31502_() <= 0) {
                stoleHealthThisTick = true;
                lifeSteals.add(new WitherLifeSteal(wither, event.getAmount(), event.getEntity().m_20182_().m_82520_(0.0, (double)(event.getEntity().m_20206_() / 2.0f), 0.0)));
            }
        }
    }

    public static class WitherLifeSteal {
        public float yRot;
        public float xRot;
        public float distance;
        public final WitherBoss wither;
        public final float health;
        public boolean removed;

        public WitherLifeSteal(WitherBoss wither, float health, Vec3 pos) {
            this.wither = wither;
            this.health = health;
            Vec2 angle = PositionUtils.rotationToFace(wither.m_20182_().m_82520_(0.0, (double)wither.m_20206_() * 0.5, 0.0), pos);
            this.xRot = angle.f_82470_;
            this.yRot = angle.f_82471_;
            this.distance = PositionUtils.distanceTo((Entity)wither, pos);
        }

        public void tick() {
            if (!MiscUtils.isEntityValid((Entity)this.wither)) {
                this.removed = true;
            }
            if (!this.removed) {
                Vec3 pos = PositionUtils.getOffsetPos(this.wither.m_20182_().m_82520_(0.0, (double)this.wither.m_20206_() * 0.5, 0.0), 0.0, 0.0, (double)this.distance, this.xRot, this.yRot);
                for (ServerPlayer player : ((ServerLevel)this.wither.m_9236_()).m_6907_()) {
                    ((ServerLevel)this.wither.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(5.0f), Float.valueOf((float)(pos.f_82479_ + this.wither.m_217043_().m_188583_() * 0.25)), Float.valueOf((float)(pos.f_82480_ + this.wither.m_217043_().m_188583_() * 0.25)), Float.valueOf((float)(pos.f_82481_ + this.wither.m_217043_().m_188583_() * 0.25))})), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.wither.m_20191_().m_82390_(pos)) {
                    this.wither.m_5634_(this.health / 2.0f);
                    this.removed = true;
                }
                this.yRot += 2.0f;
                this.distance = (float)((double)this.distance - 0.1);
            }
        }
    }
}

