/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapability;
import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.network.ClientboundUpdatePossessedMobPacket;
import com.alexander.witherreincarnated.network.Messages;
import com.alexander.witherreincarnated.utils.MiscUtils;
import java.util.function.Predicate;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="witherreincarnated")
public class HandlePossessedMobsEvent {
    public static final Predicate<Entity> POSSESSED = entity -> entity != null && entity.getCapability(PossessedCapabilityProvider.CAP).isPresent() && ((PossessedCapability)entity.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).isPossessed();

    @SubscribeEvent
    public static void possessedTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Mob) {
            Mob mob = (Mob)livingEntity;
            mob.getCapability(PossessedCapabilityProvider.CAP).ifPresent(cap -> {
                Level patt1671$temp = mob.m_9236_();
                if (patt1671$temp instanceof ServerLevel) {
                    Entity entity;
                    ServerLevel serverLevel = (ServerLevel)patt1671$temp;
                    if (cap.possessedBy == null && cap.possessedByUUID != null && (entity = serverLevel.m_8791_(cap.possessedByUUID)) != null && entity instanceof LivingEntity) {
                        LivingEntity living;
                        cap.possessedBy = living = (LivingEntity)entity;
                        cap.worldLoaded = true;
                    }
                }
                cap.tick();
                if (cap.isPossessed()) {
                    if (mob.m_9236_().f_46443_) {
                        mob.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, mob.m_20208_(0.75), mob.m_20187_(), mob.m_20262_(0.75), 0.0, 0.0, 0.0);
                        if (cap.possessedFor < 5) {
                            mob.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_235898_, mob.m_20208_(0.75), mob.m_20187_(), mob.m_20262_(0.75), 0.0, 0.0, 0.0);
                        }
                    } else {
                        mob.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 2, 0, true, false));
                    }
                    if (cap.possessedBy == null || mob.m_20270_((Entity)cap.possessedBy) > 96.0f) {
                        cap.possessedBy = null;
                        cap.possessedByUUID = null;
                        cap.possessionTime = 0;
                    }
                } else if (cap.wasPossessed) {
                    mob.m_5496_((SoundEvent)SoundEventInit.POSSESSED_UNPOSSESS.get(), 1.0f, MiscUtils.randomSoundPitch());
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 200, 0));
                    mob.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2, false, false));
                }
                if (mob.m_9236_().m_46749_(mob.m_20183_()) && cap.worldLoaded) {
                    Messages.sendToAllPlayers(new ClientboundUpdatePossessedMobPacket(mob.m_19879_(), cap.possessedBy != null ? cap.possessedBy.m_19879_() : 0, cap.possessionTime, cap.possessedFor, cap.possessionCooldown), mob.m_9236_());
                    cap.worldLoaded = false;
                }
            });
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity;
        if (event.getTarget() != null && !event.getTarget().m_9236_().f_46443_ && (entity = event.getTarget()) instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.getCapability(PossessedCapabilityProvider.CAP).ifPresent(cap -> Messages.sendToAllPlayers(new ClientboundUpdatePossessedMobPacket(mob.m_19879_(), cap.possessedBy != null ? cap.possessedBy.m_19879_() : 0, cap.possessionTime, cap.possessedFor, cap.possessionCooldown), mob.m_9236_()));
        }
    }
}

