/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.events;

import com.alexander.witherreincarnated.events.CameraShakeEvents;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.sounds.WitherLaserAttackSoundInstance;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="witherreincarnated", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class HandleAnimationsEvent {
    public static Map<WitherBoss, WitherAnimations> witherAnimations = Maps.newHashMap();

    @SubscribeEvent
    public static void updateAnimations(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof WitherBoss) {
            WitherBoss wither = (WitherBoss)livingEntity;
            if (wither.m_9236_().f_46443_) {
                if (!witherAnimations.containsKey(wither)) {
                    witherAnimations.put(wither, new WitherAnimations(wither));
                } else {
                    int i;
                    Vec3 pos;
                    WitherAnimations anims = witherAnimations.get(wither);
                    anims.constantAnimationState.m_216982_(wither.f_19797_);
                    anims.leanO = anims.lean;
                    anims.forwardLeanO = anims.forwardLean;
                    if (wither.f_20884_ > wither.f_20883_) {
                        anims.leanTick = 10;
                    } else if (wither.f_20884_ < wither.f_20883_) {
                        anims.leanTick = -10;
                    }
                    if (anims.leanTick > 0) {
                        anims.lean = Mth.m_14179_((float)0.05f, (float)anims.lean, (float)35.0f);
                        --anims.leanTick;
                    } else if (anims.leanTick < 0) {
                        anims.lean = Mth.m_14179_((float)0.05f, (float)anims.lean, (float)-35.0f);
                        ++anims.leanTick;
                    } else {
                        anims.lean = Mth.m_14179_((float)0.1f, (float)anims.lean, (float)0.0f);
                    }
                    anims.forwardLean = wither.f_267362_.m_267731_() * 40.0f;
                    Vec3 entityPos = PositionUtils.getOffsetPos(wither.m_20182_().m_82520_(0.0, (double)wither.m_20206_() * 0.5, 0.0), 0.0, 0.0, (double)wither.m_20205_() * 0.5, anims.laserAngle.f_82470_, anims.laserAngle.f_82471_);
                    if (anims.laserLength > 0.0f) {
                        pos = PositionUtils.getOffsetPos(entityPos, 0.0, 0.0, (double)anims.laserLength, anims.laserAngle.f_82470_, anims.laserAngle.f_82471_);
                        for (i = 0; i < 20; ++i) {
                            float area = 2.0f;
                            wither.m_9236_().m_7106_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(5.0f), Float.valueOf((float)pos.f_82479_), Float.valueOf((float)pos.f_82480_), Float.valueOf((float)pos.f_82481_)})), pos.f_82479_ + wither.m_217043_().m_188583_() * (double)area, pos.f_82480_ + wither.m_217043_().m_188583_() * (double)area, pos.f_82481_ + wither.m_217043_().m_188583_() * (double)area, 0.0, 0.0, 0.0);
                        }
                        CameraShakeEvents.addCameraShake(wither.m_9236_(), 2, 0.025f, BlockPos.m_274446_((Position)pos), 4);
                    }
                    if (wither.m_31502_() > 0) {
                        pos = wither.m_20182_().m_82520_(0.0, (double)wither.m_20206_() * 0.7, 0.0);
                        for (i = 0; i < 5; ++i) {
                            wither.m_9236_().m_6485_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(20.0f), Float.valueOf((float)(pos.f_82479_ + wither.m_217043_().m_188583_() * 5.0)), Float.valueOf((float)(pos.f_82480_ + wither.m_217043_().m_188583_() * 5.0)), Float.valueOf((float)(pos.f_82481_ + wither.m_217043_().m_188583_() * 5.0))})), true, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0);
                        }
                    }
                    if (!(anims.laserAngle == null || anims.laserAngle.f_82470_ == 0.0f && anims.laserAngle.f_82471_ == 0.0f || anims.laserSound != null && Minecraft.m_91087_().m_91106_().m_120403_((SoundInstance)anims.laserSound))) {
                        WitherLaserAttackSoundInstance sound;
                        anims.laserSound = sound = new WitherLaserAttackSoundInstance(anims);
                        anims.removeLaserSoundTime = 10;
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)sound);
                    }
                    if (anims.removeLaserSoundTime-- <= 0) {
                        anims.laserSound = null;
                    }
                    if (anims.stunTick > 0) {
                        --anims.stunTick;
                        if (anims.changeArmourDisplayTick > 0) {
                            --anims.changeArmourDisplayTick;
                        } else {
                            anims.displayingArmour = !anims.displayingArmour;
                            anims.changeArmourDisplayTick = 1 + wither.m_217043_().m_188503_(5);
                        }
                        for (int i2 = 0; i2 < 5; ++i2) {
                            wither.m_9236_().m_6485_((ParticleOptions)ParticleTypes.f_123811_, true, wither.m_20185_() + wither.m_217043_().m_188583_(), wither.m_20186_() + (double)(wither.m_217043_().m_188501_() * 3.3f), wither.m_20189_() + wither.m_217043_().m_188583_(), 1.0, 1.0, (double)0.7333f);
                        }
                        if (anims.stunTick == 0 && !wither.m_21224_()) {
                            Vec3 pos2 = wither.m_20182_().m_82520_(0.0, (double)wither.m_20206_() * 0.7, 0.0);
                            for (i = 0; i < 500; ++i) {
                                wither.m_9236_().m_6485_((ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(20 + wither.m_217043_().m_188503_(80)), Float.valueOf((float)pos2.f_82479_), Float.valueOf((float)pos2.f_82480_), Float.valueOf((float)pos2.f_82481_)})), true, pos2.f_82479_ + wither.m_217043_().m_188583_() * 30.0, pos2.f_82480_ + wither.m_217043_().m_188583_() * 30.0, pos2.f_82481_ + wither.m_217043_().m_188583_() * 30.0, 0.0, 0.0, 0.0);
                            }
                        }
                    } else {
                        anims.displayingArmour = true;
                    }
                    if (anims.barrageTick > 0) {
                        --anims.barrageTick;
                    }
                }
            }
        }
    }

    public static class WitherAnimations {
        public final WitherBoss wither;
        public AnimationState constantAnimationState = new AnimationState();
        public AnimationState chargeAnimationState = new AnimationState();
        public AnimationState barrageAnimationState = new AnimationState();
        public AnimationState deathAnimationState = new AnimationState();
        public float lean;
        public float leanO;
        public int leanTick;
        public float forwardLean;
        public float forwardLeanO;
        public Vec2 laserAngle = Vec2.f_82462_;
        public Vec2 laserAngleO = Vec2.f_82462_;
        public float laserLength;
        public int removeLaserSoundTime;
        public WitherLaserAttackSoundInstance laserSound;
        public int stunTick;
        public boolean displayingArmour;
        public int changeArmourDisplayTick;
        public int barrageTick;

        public WitherAnimations(WitherBoss wither) {
            this.wither = wither;
        }
    }
}

