/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.wither;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public class WitherRangedAttackGoal
extends Goal {
    private final WitherBoss mob;
    @Nullable
    private LivingEntity target;
    private int attackTime = -1;
    private final double speedModifier;
    private final float attackRadius;
    private final float attackRadiusSqr;
    private double strafeSpeed = 0.0;
    private final double maxStrafeSpeed = 0.02;
    private final double strafeSpeedChangeAmount = 5.0E-4;
    private final double maxStrafeSpeedPowered = 0.035;
    private final double strafeSpeedChangeAmountPowered = 0.001;
    private int strafeDirection = 0;
    public double lastTargetX = 0.0;
    public double lastTargetZ = 0.0;
    public boolean dangerousSkull;
    public int animationTick;

    public WitherRangedAttackGoal(WitherBoss p_25773_, double p_25774_, float p_25777_) {
        if (!(p_25773_ instanceof LivingEntity)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        this.mob = p_25773_;
        this.speedModifier = p_25774_;
        this.attackRadius = p_25777_;
        this.attackRadiusSqr = p_25777_ * p_25777_;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null && livingentity.m_6084_()) {
            this.target = livingentity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.m_8036_() || this.target.m_6084_();
    }

    public void m_8041_() {
        this.target = null;
        this.attackTime = -1;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        int animTime;
        double d0 = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        if (this.mob.m_217043_().m_188503_(40) == 0) {
            this.strafeDirection = -1 + this.mob.m_217043_().m_188503_(3);
        }
        if (!(d0 > (double)this.attackRadiusSqr) && (this.mob.m_142582_((Entity)this.target) || this.target instanceof Player)) {
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_21223_() <= this.mob.m_21233_() * 0.6666667f || ((Boolean)WRCommonConfig.vanilla_wither_phases.get()).booleanValue()) {
                double maxStrafeSpeed;
                double strafeSpeedChangeAmount = this.mob.m_7090_() ? this.strafeSpeedChangeAmountPowered : this.strafeSpeedChangeAmount;
                double d = maxStrafeSpeed = this.mob.m_7090_() ? this.maxStrafeSpeedPowered : this.maxStrafeSpeed;
                if (this.strafeDirection > 0) {
                    if (this.strafeSpeed < maxStrafeSpeed) {
                        this.strafeSpeed += strafeSpeedChangeAmount;
                    }
                } else if (this.strafeDirection < 0 && this.strafeSpeed > -maxStrafeSpeed) {
                    this.strafeSpeed -= strafeSpeedChangeAmount;
                }
                Vec3 strafe = PositionUtils.getOffsetPos(Vec3.f_82478_, this.strafeSpeed, 0.0, 0.0, 0.0f, this.mob.f_20883_);
                this.mob.m_20256_(this.mob.m_20184_().m_82549_(strafe));
            }
        } else {
            this.mob.m_21573_().m_5624_((Entity)this.target, this.speedModifier);
        }
        this.mob.m_21563_().m_24960_((Entity)this.target, 10.0f, 30.0f);
        int n = animTime = this.dangerousSkull ? 30 : 10;
        if (--this.attackTime <= 0 && --this.animationTick < 0) {
            this.dangerousSkull = this.mob.m_217043_().m_188503_(3) == 0 && !this.mob.m_7090_();
            this.animationTick = animTime = this.dangerousSkull ? 40 : 20;
        }
        if (this.attackTime <= 0 && this.animationTick == 0) {
            double predictionMultiplier = (double)this.mob.m_20270_((Entity)this.target) * 0.9;
            this.mob.m_31448_(0, this.target.m_20185_() + (this.target.m_20185_() - this.lastTargetX) * predictionMultiplier, this.target.m_20186_() + (double)this.target.m_20192_() * 0.5, this.target.m_20189_() + (this.target.m_20189_() - this.lastTargetZ) * predictionMultiplier, this.dangerousSkull);
            int n2 = this.attackTime = this.mob.m_7090_() ? 0 : 20;
        }
        if (this.animationTick > 0) {
            Vec3 shootingFrom = MiscUtils.witherHeadPos((LivingEntity)this.mob, 0, true);
            for (int i = 0; i < (this.dangerousSkull ? 5 : 2); ++i) {
                float area = 1.5f;
                for (ServerPlayer player : ((ServerLevel)this.mob.m_9236_()).m_6907_()) {
                    ((ServerLevel)this.mob.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(10.0f), Float.valueOf((float)(shootingFrom.f_82479_ + this.mob.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82480_ + this.mob.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82481_ + this.mob.m_217043_().m_188583_() * (double)area))})), true, shootingFrom.f_82479_, shootingFrom.f_82480_, shootingFrom.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.target != null) {
            this.lastTargetX = this.target.m_20185_();
            this.lastTargetZ = this.target.m_20189_();
        }
    }
}

