/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.wither;

import com.alexander.witherreincarnated.config.WRCommonConfig;
import com.alexander.witherreincarnated.init.ParticleTypeInit;
import com.alexander.witherreincarnated.init.SoundEventInit;
import com.alexander.witherreincarnated.network.ClientboundWitherStartAnimationPacket;
import com.alexander.witherreincarnated.network.Messages;
import com.alexander.witherreincarnated.particles.AdvancedParticleOption;
import com.alexander.witherreincarnated.utils.MiscUtils;
import com.alexander.witherreincarnated.utils.PositionUtils;
import com.google.common.collect.Lists;
import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.phys.Vec3;

public class WitherBarrageGoal
extends Goal {
    public final WitherBoss mob;
    public int nextUseTime = -1;
    public int useTicks;

    public WitherBarrageGoal(WitherBoss mob) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.mob = mob;
    }

    public boolean m_8036_() {
        if (((Boolean)WRCommonConfig.disable_wither_barrage_attack.get()).booleanValue()) {
            return false;
        }
        if (this.nextUseTime == -1) {
            this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_barrage_cooldown.get(), (Integer)WRCommonConfig.max_barrage_cooldown.get());
        }
        return this.mob.f_19797_ >= this.nextUseTime;
    }

    public boolean m_8045_() {
        return this.useTicks <= 150;
    }

    public void m_8056_() {
        this.useTicks = 0;
        Messages.sendToAllPlayers(new ClientboundWitherStartAnimationPacket(this.mob.m_19879_(), 2), this.mob.m_9236_());
    }

    public boolean m_6767_() {
        return false;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        ++this.useTicks;
        this.mob.m_21573_().m_26573_();
        if (this.useTicks >= 30) {
            this.mob.m_5618_(this.mob.f_20883_);
            this.mob.m_146922_(this.mob.f_20883_);
            if (this.useTicks == 30) {
                this.mob.m_5496_((SoundEvent)SoundEventInit.WITHER_BARRAGE.get(), 15.0f, 1.0f);
                Vec3 shootingFrom = this.mob.m_20182_().m_82520_(0.0, 7.5, 0.0);
                for (int i = 0; i < 2000; ++i) {
                    float area = 100.0f;
                    for (ServerPlayer player : ((ServerLevel)this.mob.m_9236_()).m_6907_()) {
                        ((ServerLevel)this.mob.m_9236_()).m_8624_(player, (ParticleOptions)new AdvancedParticleOption(ParticleTypeInit.ABSORB, Lists.newArrayList((Object[])new Float[]{Float.valueOf(1.0f), Float.valueOf(1.6777215E7f), Float.valueOf(0.1f), Float.valueOf(30.0f), Float.valueOf((float)(shootingFrom.f_82479_ + this.mob.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82480_ + this.mob.m_217043_().m_188583_() * (double)area)), Float.valueOf((float)(shootingFrom.f_82481_ + this.mob.m_217043_().m_188583_() * (double)area))})), true, shootingFrom.f_82479_, shootingFrom.f_82480_, shootingFrom.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            }
            if (this.useTicks >= 120) {
                this.mob.m_20334_(0.0, -1.0, 0.0);
            } else if (this.useTicks >= 60) {
                for (int i = 0; i < 3; ++i) {
                    WitherSkull witherskull = new WitherSkull(this.mob.m_9236_(), (LivingEntity)this.mob, this.mob.m_217043_().m_188583_() * 1.0, -2.0, this.mob.m_217043_().m_188583_() * 1.0);
                    witherskull.m_5602_((Entity)this.mob);
                    witherskull.m_20343_(this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
                    this.mob.m_9236_().m_7967_((Entity)witherskull);
                    this.mob.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.mob.m_20334_(0.0, 0.25, 0.0);
            }
        } else {
            this.mob.m_20256_(PositionUtils.getOffsetPos(Vec3.f_82478_, 0.0, 1.0, 0.8, 0.0f, this.mob.f_20883_));
            float rot = this.mob.f_20883_ + 10.0f;
            this.mob.m_5618_(rot);
            this.mob.m_146922_(rot);
        }
        this.mob.m_5616_(this.mob.f_20883_);
    }

    public void m_8041_() {
        this.nextUseTime = this.mob.f_19797_ + MiscUtils.randomIntBetween((Integer)WRCommonConfig.min_barrage_cooldown.get(), (Integer)WRCommonConfig.max_barrage_cooldown.get());
    }
}

