/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.witherreincarnated.ai.goals.possessed;

import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapability;
import com.alexander.witherreincarnated.capabilities.possessed.PossessedCapabilityProvider;
import com.alexander.witherreincarnated.events.HandlePossessedMobsEvent;
import com.alexander.witherreincarnated.utils.MiscUtils;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class PossessedFollowWitherGoal
extends Goal {
    private final Mob mob;
    @Nullable
    private LivingEntity following;
    private final double speedModifier;
    private final PathNavigation navigation;
    private int timeToRecalcPath;
    private final float stopDistance;
    private float oldWaterCost;

    public PossessedFollowWitherGoal(Mob mob, double speedModifier, float stopDistance) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.navigation = mob.m_21573_();
        this.stopDistance = stopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (MiscUtils.isEntityValid((Entity)this.mob.m_5448_()) || !HandlePossessedMobsEvent.POSSESSED.test((Entity)this.mob)) {
            return false;
        }
        LivingEntity possessedBy = ((PossessedCapability)this.mob.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).possessedBy;
        if (possessedBy != null && possessedBy.m_6084_()) {
            this.following = possessedBy;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return !MiscUtils.isEntityValid((Entity)this.mob.m_5448_()) && this.mob.getCapability(PossessedCapabilityProvider.CAP).isPresent() && ((PossessedCapability)this.mob.getCapability(PossessedCapabilityProvider.CAP).resolve().get()).isPossessed() && this.following != null && !this.navigation.m_26571_() && this.mob.m_20280_((Entity)this.following) > (double)(this.stopDistance * this.stopDistance);
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.mob.m_21439_(BlockPathTypes.WATER);
        this.mob.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.following = null;
        this.navigation.m_26573_();
        this.mob.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (this.following != null && !this.mob.m_21523_() && --this.timeToRecalcPath <= 0) {
            Vec3 target = this.following.m_20182_().m_82520_(this.mob.m_217043_().m_188583_() * 20.0, 0.0, this.mob.m_217043_().m_188583_() * 20.0).m_82520_(this.following.m_20184_().f_82479_ * 20.0, 0.0, this.following.m_20184_().f_82481_ * 20.0);
            this.timeToRecalcPath = this.m_183277_(20);
            this.navigation.m_26519_(target.f_82479_, target.f_82480_, target.f_82481_, this.speedModifier);
        }
    }
}

