/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.compat;

import com.mrcrayfish.framework.api.network.LevelLocation;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.guns.Config;
import com.mrcrayfish.guns.GunMod;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.common.ProjectileManager;
import com.mrcrayfish.guns.entity.ProjectileEntity;
import com.mrcrayfish.guns.event.GunProjectileHitEvent;
import com.mrcrayfish.guns.init.ModItems;
import com.mrcrayfish.guns.interfaces.IProjectileFactory;
import com.mrcrayfish.guns.item.GunItem;
import com.mrcrayfish.guns.item.IAmmo;
import com.mrcrayfish.guns.network.PacketHandler;
import com.mrcrayfish.guns.network.message.S2CMessageGunSound;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.przemyk.simpleplanes.entities.PlaneEntity;

public class SimplePlanesHelper {
    public static final ItemStack minigunDummy = ((Item)ModItems.MINI_GUN.get()).m_7968_();
    public static final ItemStack shotgunDummy = ((Item)ModItems.SHOTGUN.get()).m_7968_();
    public static final ItemStack heavyRifleDummy = ((Item)ModItems.HEAVY_RIFLE.get()).m_7968_();
    public static final ItemStack grenadeLauncherDummy = ((Item)ModItems.GRENADE_LAUNCHER.get()).m_7968_();
    public static final ItemStack bazookaDummy = ((Item)ModItems.BAZOOKA.get()).m_7968_();

    public static void init() {
        try {
            Class.forName("xyz.przemyk.simpleplanes.compat.MrCrayfishGunCompat");
            GunMod.LOGGER.info("Simple Planes' CGM compat detected, disabling our unofficial one...");
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            MinecraftForge.EVENT_BUS.register((Object)new SimplePlanesHelper());
            return;
        }
    }

    @SubscribeEvent
    public void onGunProjectileHit(GunProjectileHitEvent event) {
        PlaneEntity planeEntity;
        EntityHitResult entityHitResult;
        Entity entity;
        HitResult result = event.getRayTrace();
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof PlaneEntity && (planeEntity = (PlaneEntity)entity).m_20197_().contains(event.getProjectile().getShooter())) {
            event.setCanceled(true);
        }
    }

    public static void shooterBehaviour(Item ammoItem, ItemStackHandler itemStackHandler, Level level, Player player, Vec3 motion, double x, double y, double z) {
        if (ammoItem instanceof IAmmo) {
            ResourceLocation fireSound;
            ItemStack gunDummy;
            if (ModItems.BASIC_BULLET.get() == ammoItem) {
                gunDummy = minigunDummy;
            } else if (ModItems.SHELL.get() == ammoItem) {
                gunDummy = shotgunDummy;
            } else if (ModItems.ADVANCED_AMMO.get() == ammoItem) {
                gunDummy = heavyRifleDummy;
            } else if (ModItems.GRENADE.get() == ammoItem) {
                gunDummy = grenadeLauncherDummy;
            } else if (ModItems.MISSILE.get() == ammoItem) {
                gunDummy = bazookaDummy;
            } else {
                return;
            }
            GunItem gunItem = (GunItem)gunDummy.m_41720_();
            Gun gun = gunItem.getGun();
            IProjectileFactory projectileFactory = ProjectileManager.getInstance().getFactory(ForgeRegistries.ITEMS.getKey((Object)ammoItem));
            ProjectileEntity projectile = projectileFactory.create(level, (LivingEntity)player, gunDummy, gunItem, gun);
            projectile.setWeapon(gunDummy);
            projectile.m_6034_(x, y, z);
            double speed = gun.getProjectile().getSpeed();
            projectile.m_20334_(motion.f_82479_ * speed, motion.f_82480_ * speed, motion.f_82481_ * speed);
            level.m_7967_((Entity)projectile);
            if (!level.f_46443_ && (fireSound = gun.getSounds().getFire()) != null) {
                double posX = player.m_20185_();
                double posY = player.m_20186_();
                double posZ = player.m_20189_();
                float volume = 1.0f;
                float pitch = 0.9f + level.f_46441_.m_188501_() * 0.2f;
                double radius = (Double)Config.SERVER.gunShotMaxDistance.get();
                boolean muzzle = gun.getDisplay().getFlash() != null;
                S2CMessageGunSound messageSound = new S2CMessageGunSound(fireSound, SoundSource.PLAYERS, (float)posX, (float)posY, (float)posZ, volume, pitch, player.m_19879_(), muzzle, false);
                PacketHandler.getPlayChannel().sendToNearbyPlayers(() -> LevelLocation.create((Level)player.m_9236_(), (Vec3)player.m_20182_(), (double)radius), (IMessage)messageSound);
            }
            if (!player.m_7500_()) {
                itemStackHandler.extractItem(0, 1, false);
            }
        }
    }
}

