/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.info;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.info.InfoDisplay;
import xaero.hud.minimap.info.codec.InfoDisplayCommonStateCodecs;
import xaero.hud.minimap.info.widget.InfoDisplayCommonWidgetFactories;
import xaero.hud.minimap.info.widget.InfoDisplayCycleWidgetFactory;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;

public class BuiltInInfoDisplays {
    private static List<InfoDisplay<?>> ALL = new ArrayList();
    public static final InfoDisplay<Boolean> COORDINATES = InfoDisplay.Builder.begin().setId("coords").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_coords")).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        String coords = playerPos.m_123341_() + ", " + playerPos.m_123342_() + ", " + playerPos.m_123343_();
        if (Minecraft.m_91087_().f_91062_.m_92895_(coords) >= availableWidth) {
            String stringLevel = "" + playerPos.m_123342_();
            coords = playerPos.m_123341_() + ", " + playerPos.m_123343_();
            compiler.addLine(coords);
            compiler.addLine(stringLevel);
        } else {
            compiler.addLine(coords);
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> OVERWORLD_COORDINATES = InfoDisplay.Builder.begin().setId("overworld_coords").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_overworld_coords")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        double coordinateScale = mc.f_91073_.m_6042_().f_63859_();
        if (coordinateScale == 1.0) {
            return;
        }
        int overworldPlayerX = Mth.m_14107_((double)((double)playerPos.m_123341_() * coordinateScale));
        int overworldPlayerZ = Mth.m_14107_((double)((double)playerPos.m_123343_() * coordinateScale));
        String coords = "Xo: " + overworldPlayerX + ", Zo: " + overworldPlayerZ;
        compiler.addWords(coords);
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> CHUNK_COORDINATES = InfoDisplay.Builder.begin().setId("chunk_coords").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_chunk_coords")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        int chunkX = playerPos.m_123341_() >> 4;
        int chunkZ = playerPos.m_123343_() >> 4;
        int insideX = playerPos.m_123341_() & 0xF;
        int insideZ = playerPos.m_123343_() & 0xF;
        String coords = "C " + chunkX + ", " + chunkZ + " (" + insideX + "; " + insideZ + ")";
        compiler.addWords(coords);
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> ANGLES = InfoDisplay.Builder.begin().setId("angles").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_angles")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        compiler.addLine((Component)Component.m_237113_((String)String.format("%.1f / %.1f", Float.valueOf(Mth.m_14177_((float)mc.m_91288_().m_146908_())), Float.valueOf(Mth.m_14177_((float)mc.m_91288_().m_146909_())))));
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> DIMENSION = InfoDisplay.Builder.begin().setId("dimension").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_dimension")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        ResourceLocation dimensionId = Minecraft.m_91087_().f_91073_.m_46472_().m_135782_();
        if (dimensionId != null) {
            String dimensionName = dimensionId.m_135827_().equals("minecraft") ? dimensionId.m_135815_() : dimensionId.toString();
            compiler.addLine(dimensionName);
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> BIOME = InfoDisplay.Builder.begin().setId("biome").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_biome")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        Holder biomeHolder = Minecraft.m_91087_().f_91073_.m_204166_(playerPos);
        Biome biome = biomeHolder == null ? null : (Biome)biomeHolder.m_203334_();
        ResourceLocation biomeRL = biome == null ? null : Minecraft.m_91087_().f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_7981_((Object)biome);
        String biomeText = biomeRL == null ? I18n.m_118938_((String)"gui.xaero_unknown_biome", (Object[])new Object[0]) : I18n.m_118938_((String)("biome." + biomeRL.m_135827_() + "." + biomeRL.m_135815_()), (Object[])new Object[0]);
        compiler.addWords(biomeText);
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> WEATHER = InfoDisplay.Builder.begin().setId("weather").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_weather")).setDefaultState(false).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.OFF_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (Minecraft.m_91087_().f_91073_.m_46470_()) {
            compiler.addLine((Component)Component.m_237115_((String)"gui.xaero_weather_thundering"));
        } else if (Minecraft.m_91087_().f_91073_.m_46471_()) {
            compiler.addLine((Component)Component.m_237115_((String)"gui.xaero_weather_raining"));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Integer> LIGHT_LEVEL = InfoDisplay.Builder.begin().setId("light_level").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_light_level")).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.xaero_off"), Component.m_237115_((String)"gui.xaero_light_block"), Component.m_237115_((String)"gui.xaero_light_sky"), Component.m_237115_((String)"gui.xaero_light_all"), Component.m_237115_((String)"gui.xaero_light_both2")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showLightLevel = (Integer)displayInfo.getState();
        if (showLightLevel == 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        int blockLight = mc.f_91073_.m_45517_(LightLayer.BLOCK, playerPos);
        int skyLight = mc.f_91073_.m_45517_(LightLayer.SKY, playerPos);
        if (showLightLevel == 1) {
            compiler.addLine((Component)Component.m_237110_((String)"gui.xaero_block_light_value", (Object[])new Object[]{blockLight}));
        } else if (showLightLevel == 2) {
            compiler.addLine((Component)Component.m_237110_((String)"gui.xaero_sky_light_value", (Object[])new Object[]{skyLight}));
        } else if (showLightLevel == 3) {
            compiler.addLine((Component)Component.m_237110_((String)"gui.xaero_all_light_value", (Object[])new Object[]{Math.max(blockLight, skyLight)}));
        } else {
            compiler.addLine((Component)Component.m_237110_((String)"gui.xaero_both_light_value", (Object[])new Object[]{blockLight, skyLight}));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Integer> TIME = InfoDisplay.Builder.begin().setId("time").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_time")).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2, 3, 4}), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.xaero_off"), Component.m_237110_((String)"%s+%s", (Object[])new Object[]{Component.m_237115_((String)"gui.xaero_day"), Component.m_237115_((String)"gui.xaero_24h")}), Component.m_237110_((String)"%s+%s", (Object[])new Object[]{Component.m_237115_((String)"gui.xaero_day"), Component.m_237115_((String)"gui.xaero_12h")}), Component.m_237115_((String)"gui.xaero_24h"), Component.m_237115_((String)"gui.xaero_12h")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        long totalTime = 6000L + mc.f_91073_.m_46468_();
        int dayNumber = (int)(totalTime / 24000L) + 1;
        int dayTimeSinceMidnight = (int)(totalTime % 24000L);
        int timeHours = dayTimeSinceMidnight / 1000;
        int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
        if ((showTime - 1) % 2 == 0) {
            if (showTime < 3) {
                compiler.addWords(I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d", dayNumber, timeHours, minutes));
            } else {
                compiler.addWords(String.format("%02d:%02d", timeHours, minutes));
            }
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            if (showTime < 3) {
                compiler.addWords(I18n.m_118938_((String)"gui.xaero_day", (Object[])new Object[0]) + String.format(" %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
            } else {
                compiler.addWords(String.format("%02d:%02d %s", timeHours, minutes, half));
            }
        }
    }).setDestination(ALL::add).build();
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final InfoDisplay<Integer> REAL_TIME = InfoDisplay.Builder.begin().setId("real_time").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_real_time")).setDefaultState(0).setCodec(InfoDisplayCommonStateCodecs.INTEGER).setWidgetFactory(new InfoDisplayCycleWidgetFactory(Lists.newArrayList((Object[])new Integer[]{0, 1, 2}), Lists.newArrayList((Object[])new Component[]{Component.m_237115_((String)"gui.xaero_off"), Component.m_237115_((String)"gui.xaero_24h"), Component.m_237115_((String)"gui.xaero_12h")}))).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        int showTime = (Integer)displayInfo.getState();
        if (showTime <= 0) {
            return;
        }
        CALENDAR.setTimeInMillis(System.currentTimeMillis());
        int timeHours = CALENDAR.get(11);
        int minutes = CALENDAR.get(12);
        if (showTime == 1) {
            compiler.addWords(String.format("%02d:%02d IRL", timeHours, minutes));
        } else {
            String half = "AM";
            if (timeHours >= 12) {
                timeHours -= 12;
                half = "PM";
            }
            if (timeHours == 0) {
                timeHours = 12;
            }
            compiler.addWords(String.format("%02d:%02d %s IRL", timeHours, minutes, half));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> HIGHLIGHTS = InfoDisplay.Builder.begin().setId("highlights").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_highlights")).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (session.getProcessor().getMinimapWriter().getDimensionHighlightHandler() != null) {
            session.getProcessor().getMinimapWriter().getDimensionHighlightHandler().addBlockHighlightTooltips(compiler, playerPos.m_123341_(), playerPos.m_123343_(), availableWidth, true);
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> LIGHT_OVERLAY_INDICATOR = InfoDisplay.Builder.begin().setId("light_overlay_indicator").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_light_overlay_indicator")).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (session.getModMain().getSettings().lightOverlayType > 0) {
            compiler.addWords(I18n.m_118938_((String)"gui.xaero_light_overlay_status", (Object[])new Object[0]));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> MANUAL_CAVE_MODE_INDICATOR = InfoDisplay.Builder.begin().setId("manual_cave_mode_indicator").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_manual_cave_mode_indicator")).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, session, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        if (session.getProcessor().isManualCaveMode()) {
            compiler.addWords(I18n.m_118938_((String)"gui.xaero_manual_cave_mode", (Object[])new Object[0]));
        }
    }).setDestination(ALL::add).build();
    public static final InfoDisplay<Boolean> CUSTOM_SUB_WORLD = InfoDisplay.Builder.begin().setId("custom_sub_world").setName((Component)Component.m_237115_((String)"gui.xaero_infodisplay_custom_sub_world")).setDefaultState(true).setCodec(InfoDisplayCommonStateCodecs.BOOLEAN).setWidgetFactory(InfoDisplayCommonWidgetFactories.ALWAYS_ON).setCompiler((displayInfo, compiler, hudSession, availableWidth, playerPos) -> {
        if (!((Boolean)displayInfo.getState()).booleanValue()) {
            return;
        }
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager minimapWorldManager = session.getWorldManager();
        MinimapWorld currentWorld = minimapWorldManager.getCurrentWorld();
        if (currentWorld != null && minimapWorldManager.getAutoWorld() != currentWorld) {
            compiler.addWords(I18n.m_118938_((String)"gui.xaero_using_custom_subworld", (Object[])new Object[]{currentWorld.getContainer().getSubName()}));
        }
    }).setDestination(ALL::add).build();

    public static void forEach(Consumer<InfoDisplay<?>> action) {
        ALL.forEach(action);
    }
}

