/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.network;

import computer.heather.advancedbackups.client.ClientWrapper;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;

public class PacketBackupStatus {
    public boolean starting;
    public boolean started;
    public boolean failed;
    public boolean finished;
    public boolean cancelled;
    public int progress;
    public int max;

    public PacketBackupStatus(boolean starting, boolean started, boolean failed, boolean finished, boolean cancelled, int progress, int max) {
        this.starting = starting;
        this.started = started;
        this.failed = failed;
        this.finished = finished;
        this.cancelled = cancelled;
        this.progress = progress;
        this.max = max;
    }

    public PacketBackupStatus(FriendlyByteBuf buf) {
        this.starting = buf.readBoolean();
        this.started = buf.readBoolean();
        this.failed = buf.readBoolean();
        this.finished = buf.readBoolean();
        this.cancelled = buf.readBoolean();
        this.progress = buf.readInt();
        this.max = buf.readInt();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.starting);
        buf.writeBoolean(this.started);
        buf.writeBoolean(this.failed);
        buf.writeBoolean(this.finished);
        buf.writeBoolean(this.cancelled);
        buf.writeInt(this.progress);
        buf.writeInt(this.max);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                ClientWrapper.handle(this);
            }
        });
        ctx.get().setPacketHandled(true);
        return true;
    }
}

