/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.obscureapi.api.utils;

import com.obscuria.obscureapi.api.utils.UnsafeRunnable;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionFilter {
    public static void of(UnsafeRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void of(UnsafeRunnable runnable, Consumer<Exception> catcher) {
        try {
            runnable.run();
        }
        catch (Exception e) {
            catcher.accept(e);
        }
    }

    public static <T> boolean equals(T value, Callable<T> callable) {
        try {
            return value.equals(callable.call());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public static <T> boolean equals(T value, Callable<T> callable, Consumer<Exception> catcher) {
        try {
            return value.equals(callable.call());
        }
        catch (Exception e) {
            catcher.accept(e);
            return false;
        }
    }

    @Nullable
    public static <T> T get(T value, Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (Exception ignored) {
            return value;
        }
    }

    @Nullable
    public static <T> T get(T value, Callable<T> callable, Consumer<Exception> catcher) {
        try {
            return callable.call();
        }
        catch (Exception e) {
            catcher.accept(e);
            return value;
        }
    }

    @Nonnull
    public static <T> T getNoNull(@Nonnull T value, Callable<T> callable) {
        try {
            T t = callable.call();
            return t == null ? value : t;
        }
        catch (Exception ignored) {
            return value;
        }
    }

    @Nonnull
    public static <T> T getNoNull(@Nonnull T value, Callable<T> callable, Consumer<Exception> catcher) {
        try {
            T t = callable.call();
            return t == null ? value : t;
        }
        catch (Exception e) {
            catcher.accept(e);
            return value;
        }
    }
}

