/*
 * Decompiled with CFR 0.152.
 */
package com.github.darkpred.morehitboxes.api;

import com.github.darkpred.morehitboxes.api.EntityHitboxData;
import com.github.darkpred.morehitboxes.api.MultiPart;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public interface MultiPartEntity<T extends Mob> {
    public EntityHitboxData<T> getEntityHitboxData();

    public boolean partHurt(MultiPart<T> var1, @NotNull DamageSource var2, float var3);

    default public AABB makeAttackBoundingBox(float scaledHeadRadius) {
        Mob mob = (Mob)this;
        if (scaledHeadRadius == 0.0f) {
            float increase = Math.min(mob.m_20205_() / 2.0f, 2.25f);
            return this.inflateAABB(mob.m_20191_(), increase, increase, increase);
        }
        float radius = scaledHeadRadius * 0.9f;
        return this.inflateAABB(mob.m_20191_(), radius, (double)radius * 0.55, radius);
    }

    default public AABB makeBoundingBoxForCulling(float frustumWidthRadius, float frustumHeight) {
        Mob mob = (Mob)this;
        float x = frustumWidthRadius * mob.m_6134_();
        float y = frustumHeight * mob.m_6134_();
        Vec3 pos = mob.m_20182_();
        return new AABB(pos.f_82479_ - (double)x, pos.f_82480_, pos.f_82481_ - (double)x, pos.f_82479_ + (double)x, pos.f_82480_ + (double)y, pos.f_82481_ + (double)x);
    }

    private AABB inflateAABB(AABB base, double x, double y, double z) {
        return new AABB(base.f_82288_ - x, base.f_82289_ - Math.min(1.0, y), base.f_82290_ - z, base.f_82291_ + x, base.f_82292_ + y, base.f_82293_ + z);
    }

    default public boolean attackBoxHit(Player player) {
        return true;
    }
}

