/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;
import org.jetbrains.annotations.NotNull;

public class AdvancementData
extends SavedData {
    private final Set<UUIDPair> data = new HashSet<UUIDPair>();

    public static AdvancementData load(CompoundTag compound) {
        AdvancementData data = new AdvancementData();
        data.data.clear();
        ListTag incoming = compound.m_128437_("data", 10);
        for (int i = 0; i < incoming.size(); ++i) {
            data.data.add(UUIDPair.fromNBT(incoming.m_128728_(i)));
        }
        return data;
    }

    public boolean contains(UUID first, UUID second) {
        return this.contains(new UUIDPair(first, second));
    }

    public boolean contains(UUIDPair pair) {
        return this.data.contains(pair);
    }

    public void add(UUID first, UUID second) {
        this.add(new UUIDPair(first, second));
    }

    public void add(UUIDPair pair) {
        this.data.add(pair);
    }

    public CompoundTag m_7176_(CompoundTag pCompound) {
        ListTag result = new ListTag();
        for (UUIDPair pair : this.data) {
            result.add((Object)pair.serializeNBT());
        }
        pCompound.m_128365_("data", (Tag)result);
        return pCompound;
    }

    public void m_77757_(File pFile) {
        if (this.m_77764_()) {
            pFile.getParentFile().mkdirs();
        }
        super.m_77757_(pFile);
    }

    public static class UUIDPair
    implements INBTSerializable<CompoundTag> {
        @NotNull
        private UUID first;
        private UUID second;

        protected UUIDPair() {
        }

        public UUIDPair(@NotNull UUID first, @NotNull UUID second) {
            this.first = first;
            this.second = second;
        }

        public static UUIDPair fromNBT(CompoundTag tag) {
            UUIDPair pair = new UUIDPair();
            pair.deserializeNBT(tag);
            return pair;
        }

        @NotNull
        public UUID getFirst() {
            return this.first;
        }

        @NotNull
        public UUID getSecond() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UUIDPair uuidPair = (UUIDPair)o;
            if (!this.first.equals(uuidPair.first)) {
                return false;
            }
            return this.second.equals(uuidPair.second);
        }

        public int hashCode() {
            int result = this.first.hashCode();
            result = 31 * result + this.second.hashCode();
            return result;
        }

        public CompoundTag serializeNBT() {
            CompoundTag result = new CompoundTag();
            result.m_128362_("first", this.getFirst());
            result.m_128362_("second", this.getSecond());
            return result;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.first = nbt.m_128342_("first");
            this.second = nbt.m_128342_("second");
        }
    }
}

