/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.projectile.IgniterFireballEntity;
import com.yellowbrossproductions.illageandspillage.packet.PacketHandler;
import com.yellowbrossproductions.illageandspillage.packet.ParticlePacket;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;

public class IgniterEntity
extends AbstractIllager {
    public static final int FIREBALLS_TO_OVERHEAT = 25;
    public static final int COOLDOWN_TIME = 300;
    private static final EntityDataAccessor<Boolean> ATTACKING = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> TORCH_BURNT_OUT = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> FIREBALLS_SHOT = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> COOLDOWN_TICKS = SynchedEntityData.m_135353_(IgniterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private int shootTicks;
    private int fireballTimer;

    public IgniterEntity(EntityType<? extends AbstractIllager> p_i48556_1_, Level p_i48556_2_) {
        super(p_i48556_1_, p_i48556_2_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new ShootFireballsGoal());
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 0.8, 1.0, p_234199_0_ -> this.isOverheated()));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, IronGolem.class, 8.0f, 0.8, 1.0, p_234199_0_ -> this.isOverheated()));
        this.f_21345_.m_25352_(2, (Goal)new Raider.HoldGroundAttackGoal((Raider)this, (AbstractIllager)this, 10.0f));
        this.f_21345_.m_25352_(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 15.0f));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Sheep.class, 10, false, false, p_234199_0_ -> p_234199_0_ instanceof Sheep && ((Sheep)p_234199_0_).m_29874_() == DyeColor.PINK));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, 10, false, false, Entity::m_6060_));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, false));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.35f).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKING, (Object)false);
        this.f_19804_.m_135372_(TORCH_BURNT_OUT, (Object)false);
        this.f_19804_.m_135372_(FIREBALLS_SHOT, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(COOLDOWN_TICKS, (Object)Float.valueOf(0.0f));
    }

    public boolean m_6779_(LivingEntity p_186270_) {
        return (!(p_186270_ instanceof Player) || this.m_9236_().m_46791_() != Difficulty.PEACEFUL) && p_186270_.m_142066_();
    }

    public void m_7895_(int p_213660_1_, boolean p_213660_2_) {
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_6084_()) {
            this.shootTicks = this.isAttacking() ? ++this.shootTicks : 0;
            if (this.getFireballsShot() > 0.0f) {
                if (!this.isAttacking()) {
                    ++this.fireballTimer;
                    if (this.fireballTimer > 20) {
                        this.fireballTimer = 0;
                        this.setFireballsShot(this.getFireballsShot() - 1.0f);
                    }
                } else {
                    this.fireballTimer = 0;
                }
            }
            if (this.getFireballsShot() > 25.0f) {
                this.setCooldownTicks(300.0f);
                this.m_5496_(SoundEvents.f_11914_, 1.0f, 0.8f);
                this.setFireballsShot(0.0f);
            }
            if (this.getCooldownTicks() / 300.0f > 0.6f || (this.isOverheated() || !this.isOverheated() && this.getFireballsShot() / 25.0f > 0.6f) && this.f_19796_.m_188503_(5) == 0) {
                this.makeOverheatParticles();
            }
            this.setCooldownTicks(this.getCooldownTicks() - 1.0f);
            if (this.getCooldownTicks() < 0.0f) {
                this.setCooldownTicks(0.0f);
            }
            if (this.shootTicks >= 4) {
                this.m_5496_(SoundEvents.f_11798_, 1.0f, 1.0f);
                if (this.m_5448_() != null) {
                    if (this.isTorchBurntOut()) {
                        this.shootSnowball(this.m_5448_());
                    } else {
                        this.m_5496_(SoundEvents.f_11874_, 1.0f, 1.0f);
                        this.shootFireball(this.m_5448_());
                        this.setFireballsShot(this.getFireballsShot() + 1.0f);
                    }
                }
                this.shootTicks = 0;
            }
            if (this.m_5448_() instanceof Raider && !EntityUtil.isEntityCrazyRagno((Entity)this.m_5448_()) && EntityUtil.isMobNotOnOtherTeam((Entity)this.m_5448_(), (Mob)this)) {
                if (!this.m_9236_().f_46443_) {
                    this.setTorchBurntOut(true);
                }
                if (!this.m_5448_().m_6060_()) {
                    this.m_6710_(null);
                }
            } else if (!this.m_9236_().f_46443_) {
                this.setTorchBurntOut(false);
            }
        }
    }

    public void makeOverheatParticles() {
        if (!this.m_9236_().f_46443_) {
            Iterator var1 = ((ServerLevel)this.m_9236_()).m_6907_().iterator();
            while (true) {
                if (!var1.hasNext()) {
                    return;
                }
                ServerPlayer serverPlayer = (ServerPlayer)var1.next();
                if (!(serverPlayer.m_20280_((Entity)this) < 4096.0)) continue;
                ParticlePacket packet = new ParticlePacket();
                packet.queueParticle((ParticleOptions)ParticleTypes.f_123762_, false, new Vec3(this.m_20208_(0.15) + (-0.5 + this.f_19796_.m_188500_()), this.m_20227_(this.f_19796_.m_188500_() / 2.0) + 1.0, this.m_20262_(0.15) + (-0.5 + this.f_19796_.m_188500_())), new Vec3(0.0, 0.0, 0.0));
                ServerPlayer finalServerPlayer = serverPlayer;
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> finalServerPlayer), (Object)packet);
            }
        }
    }

    public void shootSnowball(LivingEntity p_82196_1_) {
        Snowball snowballentity = new Snowball(this.m_9236_(), (LivingEntity)this);
        double d0 = p_82196_1_.m_20188_() - (double)1.1f;
        double d1 = p_82196_1_.m_20185_() - this.m_20185_();
        double d2 = d0 - snowballentity.m_20186_();
        double d3 = p_82196_1_.m_20189_() - this.m_20189_();
        float f = (float)(Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f);
        snowballentity.m_6034_(snowballentity.m_20185_(), this.m_20227_(0.5), snowballentity.m_20189_());
        snowballentity.m_6686_(d1, d2 + (double)f, d3, 1.6f, 12.0f);
        this.m_9236_().m_7967_((Entity)snowballentity);
    }

    public void shootFireball(LivingEntity target) {
        double d0 = this.m_20280_((Entity)target);
        double d1 = target.m_20185_() - this.m_20185_();
        double d2 = target.m_20227_(0.5) - this.m_20227_(0.5);
        double d3 = target.m_20189_() - this.m_20189_();
        float f = (float)(Math.sqrt(Math.sqrt(d0)) * 0.5);
        IgniterFireballEntity fireballentity = new IgniterFireballEntity(this.m_9236_(), (LivingEntity)this, d1 + this.m_217043_().m_188583_() * (double)f, d2, d3 + this.m_217043_().m_188583_() * (double)f);
        fireballentity.m_6034_(fireballentity.m_20185_(), this.m_20227_(0.5), fireballentity.m_20189_());
        this.m_9236_().m_7967_((Entity)fireballentity);
    }

    public SoundEvent m_7930_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_IGNITER_CELEBRATE.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_IGNITER_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_IGNITER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)IllageAndSpillageSoundEvents.ENTITY_IGNITER_DEATH.get();
    }

    public boolean isAttacking() {
        return (Boolean)this.f_19804_.m_135370_(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.f_19804_.m_135381_(ATTACKING, (Object)attacking);
    }

    public boolean isTorchBurntOut() {
        return (Boolean)this.f_19804_.m_135370_(TORCH_BURNT_OUT);
    }

    public void setTorchBurntOut(boolean burnt) {
        this.f_19804_.m_135381_(TORCH_BURNT_OUT, (Object)burnt);
    }

    public float getFireballsShot() {
        return ((Float)this.f_19804_.m_135370_(FIREBALLS_SHOT)).floatValue();
    }

    public void setFireballsShot(float fireballsShot) {
        this.f_19804_.m_135381_(FIREBALLS_SHOT, (Object)Float.valueOf(fireballsShot));
    }

    public float getCooldownTicks() {
        return ((Float)this.f_19804_.m_135370_(COOLDOWN_TICKS)).floatValue();
    }

    public void setCooldownTicks(float cooldownTicks) {
        this.f_19804_.m_135381_(COOLDOWN_TICKS, (Object)Float.valueOf(cooldownTicks));
    }

    public boolean isOverheated() {
        return this.getCooldownTicks() > 0.0f;
    }

    public boolean m_7327_(Entity p_70652_1_) {
        return false;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        if (entity instanceof Sheep && ((Sheep)entity).m_29874_() == DyeColor.PINK && this.m_5448_() == entity) {
            this.m_5496_(this.m_7930_(), 1.0f, 1.0f);
        }
        return super.m_214076_(level, entity);
    }

    class ShootFireballsGoal
    extends Goal {
        public ShootFireballsGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return IgniterEntity.this.m_5448_() != null && IgniterEntity.this.m_20280_((Entity)IgniterEntity.this.m_5448_()) < 90.0 && IgniterEntity.this.m_142582_((Entity)IgniterEntity.this.m_5448_()) && !IgniterEntity.this.isOverheated();
        }

        public void m_8056_() {
            IgniterEntity.this.setAttacking(true);
            IgniterEntity.this.m_5496_(SoundEvents.f_12088_, 1.0f, 0.6f);
        }

        public boolean m_8045_() {
            return IgniterEntity.this.m_5448_() != null && IgniterEntity.this.m_20280_((Entity)IgniterEntity.this.m_5448_()) < 90.0 && IgniterEntity.this.m_5448_().m_6084_() && IgniterEntity.this.m_142582_((Entity)IgniterEntity.this.m_5448_()) && !IgniterEntity.this.isOverheated();
        }

        public void m_8037_() {
            IgniterEntity.this.m_21573_().m_26573_();
            if (IgniterEntity.this.m_5448_() != null) {
                IgniterEntity.this.m_21563_().m_24960_((Entity)IgniterEntity.this.m_5448_(), 30.0f, 30.0f);
            }
            IgniterEntity.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            IgniterEntity.this.setAttacking(false);
            IgniterEntity.this.m_5496_(SoundEvents.f_12088_, 1.0f, 0.5f);
        }
    }
}

