/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.entities;

import com.yellowbrossproductions.illageandspillage.entities.CameraShakeEntity;
import com.yellowbrossproductions.illageandspillage.entities.IllagerAttack;
import com.yellowbrossproductions.illageandspillage.util.EntityUtil;
import com.yellowbrossproductions.illageandspillage.util.IllageAndSpillageSoundEvents;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidType;

public class CrashagerEntity
extends Monster
implements IllagerAttack {
    private static final EntityDataAccessor<Integer> ATTACKSTAGE = SynchedEntityData.m_135353_(CrashagerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int spawnTicks;
    private Mob owner;
    private double targetX;
    private double targetY;
    private double targetZ;

    public CrashagerEntity(EntityType<? extends Monster> p_i48553_1_, Level p_i48553_2_) {
        super(p_i48553_1_, p_i48553_2_);
        this.m_274367_(1.0f);
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new AttackGoal());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, (double)0.8f).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22281_, 15.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ATTACKSTAGE, (Object)0);
    }

    public boolean m_142535_(float p_225503_1_, float p_225503_2_, DamageSource p_147189_) {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return true;
    }

    public void m_8119_() {
        if (this.m_6084_()) {
            if (this.getOwner() != null) {
                if (this.m_20096_()) {
                    ++this.spawnTicks;
                    if (this.getAttackStage() == 0) {
                        this.setAttackStage(1);
                    }
                    this.m_146922_(this.m_6080_());
                    this.f_20883_ = this.m_146908_();
                }
                if (this.spawnTicks == 15) {
                    this.m_5496_((SoundEvent)IllageAndSpillageSoundEvents.ENTITY_MAGISPELLER_RAVAGER_ROAR.get(), 3.0f, this.m_6100_());
                    CameraShakeEntity.cameraShake(this.m_9236_(), this.m_20182_(), 50.0f, 0.4f, 0, 20);
                    this.setAttackStage(2);
                    if (this.m_5448_() != null) {
                        this.targetX = this.m_5448_().m_20185_();
                        this.targetY = this.m_5448_().m_20186_();
                        this.targetZ = this.m_5448_().m_20189_();
                    }
                }
                if (this.spawnTicks == 30) {
                    this.setAttackStage(3);
                }
                if (this.spawnTicks > 70) {
                    this.explode();
                    this.m_6074_();
                }
                if (this.m_20185_() - this.targetX < 2.0 && this.m_20185_() - this.targetX > -2.0 && this.m_20186_() - this.targetY < 2.0 && this.m_20186_() - this.targetY > -2.0 && this.m_20189_() - this.targetZ < 2.0 && this.m_20189_() - this.targetZ > -2.0) {
                    this.explode();
                    this.m_6074_();
                }
            }
            for (Entity entity : this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82400_(15.0))) {
                if (!EntityUtil.canHurtThisMob(entity, (Mob)this) || !(entity instanceof LivingEntity) || !entity.m_6084_()) continue;
                double x = this.m_20185_() - entity.m_20185_();
                double y = this.m_20186_() - entity.m_20186_();
                double z = this.m_20189_() - entity.m_20189_();
                double d = Math.sqrt(x * x + y * y + z * z);
                if (!(this.m_20280_(entity) < 9.0)) continue;
                if (entity.f_19802_ <= 0) {
                    this.m_5496_(SoundEvents.f_12314_, 1.0f, 1.0f);
                }
                entity.m_6469_(this.m_269291_().m_269104_((Entity)this, (Entity)this), (float)Objects.requireNonNull(this.m_21051_(Attributes.f_22281_)).m_22115_());
                entity.f_19864_ = true;
                entity.m_20334_(-x / d * 2.0, -y / d * 2.0 + 0.5, -z / d * 2.0);
                entity.m_6001_(-x / d * 2.0, -y / d * 2.0 + 0.5, -z / d * 2.0);
            }
            if (this.getAttackStage() < 3) {
                this.m_21573_().m_26573_();
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
                this.f_21344_.m_26573_();
            } else if (this.targetX != 0.0 && this.targetY != 0.0 && this.targetZ != 0.0) {
                this.m_21573_().m_26519_(this.targetX, this.targetY, this.targetZ, 1.0);
                if (this.m_5448_() != null) {
                    this.m_21563_().m_24960_((Entity)this.m_5448_(), 30.0f, 30.0f);
                }
            }
        }
        super.m_8119_();
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return null;
    }

    protected SoundEvent m_5592_() {
        return null;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12361_;
    }

    protected void m_7355_(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.m_5496_(this.getStepSound(), 1.0f, 1.0f);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return (source.m_276093_(DamageTypes.f_268724_) || source.m_276093_(DamageTypes.f_286979_)) && super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource p_70645_1_) {
        super.m_6667_(p_70645_1_);
        if (this.m_9236_().f_46443_) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123812_, this.m_20185_(), this.m_20186_(), this.m_20189_(), d0, d1, d2);
        }
        this.f_20919_ = 19;
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0f, Level.ExplosionInteraction.NONE);
        }
    }

    public Mob getOwner() {
        return this.owner;
    }

    public void setOwner(Mob owner) {
        this.owner = owner;
    }

    public int getAttackStage() {
        return (Integer)this.f_19804_.m_135370_(ATTACKSTAGE);
    }

    public void setAttackStage(int attackStage) {
        this.f_19804_.m_135381_(ATTACKSTAGE, (Object)attackStage);
    }

    class AttackGoal
    extends Goal {
        AttackGoal() {
        }

        public boolean m_8036_() {
            return CrashagerEntity.this.getAttackStage() > 0;
        }

        public void m_8037_() {
        }
    }
}

