/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.CustomHeadedModel;
import com.yellowbrossproductions.illageandspillage.client.model.animation.MagispellerAnimation;
import com.yellowbrossproductions.illageandspillage.entities.MagispellerEntity;
import java.util.Calendar;
import java.util.Random;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;

public class MagispellerModel<T extends Entity>
extends HierarchicalModel<T>
implements CustomHeadedModel,
ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "magispeller"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final Random random = new Random();

    public MagispellerModel(ModelPart root) {
        this.root = root;
        this.body = root.m_171324_("body");
        this.left_leg = root.m_171324_("left_leg");
        this.right_leg = root.m_171324_("right_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition arms = body.m_171599_("arms", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)3.5f, (float)0.3f));
        PartDefinition arms_rotation = arms.m_171599_("arms_rotation", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-8.0f, 0.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(40, 38).m_171488_(-4.0f, 4.0f, -2.0f, 8.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-2.0f, (float)0.05f, (float)-0.7505f, (float)0.0f, (float)0.0f));
        arms_rotation.m_171599_("arms_flipped", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171480_().m_171488_(4.0f, -24.0f, -2.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 46).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 0).m_171488_(-4.0f, -14.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171488_(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.0f, (float)-4.0f));
        head.m_171599_("eyebrow1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171514_(0, 3).m_171488_(-3.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)-4.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        head.m_171599_("eyebrow2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171480_().m_171488_(0.0f, -2.0f, 0.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 3).m_171488_(2.0f, -1.0f, 0.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-4.0f, (float)-4.0f, (float)-5.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition santahat1 = head.m_171599_("santahat1", CubeListBuilder.m_171558_().m_171514_(56, 56).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(1.0f)), PartPose.m_171423_((float)0.0f, (float)-13.0f, (float)0.0f, (float)-0.6981f, (float)0.6109f, (float)0.0f));
        PartDefinition santahat2 = santahat1.m_171599_("santahat2", CubeListBuilder.m_171558_().m_171514_(56, 56).m_171480_().m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)-1.0472f, (float)0.0f, (float)0.0f));
        PartDefinition santahat3 = santahat2.m_171599_("santahat3", CubeListBuilder.m_171558_().m_171514_(56, 56).m_171488_(-1.0f, -6.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)-0.8727f, (float)0.0f, (float)0.0f));
        santahat3.m_171599_("santahat4", CubeListBuilder.m_171558_().m_171514_(28, 58).m_171488_(-1.5f, -3.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.0f, (float)0.0f));
        PartDefinition birthday = head.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(48, 14).m_171488_(-2.0f, -3.0f, -2.0f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(36, 14).m_171488_(-1.5f, -6.0f, -1.5f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(58, 21).m_171488_(-1.5f, -9.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-14.0f, (float)0.0f));
        birthday.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(58, 21).m_171488_(-1.5f, -3.0f, 0.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f));
        partdefinition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-6.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        ModelPart var10000;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        ModelPart left_arm = this.body.m_171324_("left_arm");
        ModelPart right_arm = this.body.m_171324_("right_arm");
        ModelPart arms = this.body.m_171324_("arms");
        if (entity instanceof MagispellerEntity) {
            MagispellerEntity magispeller = (MagispellerEntity)entity;
            this.m_233385_(magispeller.getAnimationState("fireball"), MagispellerAnimation.FIREBALL, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("lifesteal"), MagispellerAnimation.LIFESTEAL, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("fakers"), MagispellerAnimation.FAKERS, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("vexes"), MagispellerAnimation.VEXES, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("fangrun"), MagispellerAnimation.FANGRUN, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("potions"), MagispellerAnimation.POTIONS, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("crossbowspin"), MagispellerAnimation.CROSSBOWSPIN, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("crashager"), MagispellerAnimation.CRASHAGER, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("dispenser"), MagispellerAnimation.DISPENSER, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("knockback"), MagispellerAnimation.KNOCKBACK, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("kaboomer"), MagispellerAnimation.KABOOMER, ageInTicks, magispeller.getAnimationSpeed());
            this.m_233385_(magispeller.getAnimationState("death"), MagispellerAnimation.DEATH, ageInTicks, magispeller.getAnimationSpeed());
            Calendar calendar = Calendar.getInstance();
            this.body.m_171324_((String)"head").m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8 && magispeller.getGlowState() != 5;
            left_arm.f_104207_ = magispeller.shouldShowArms() || magispeller.isFaking();
            right_arm.f_104207_ = magispeller.shouldShowArms() || magispeller.isFaking();
            arms.f_104207_ = !magispeller.shouldShowArms() && !magispeller.isFaking();
            var10000 = this.body;
            var10000.f_104200_ += (-0.5f + this.random.nextFloat()) / 20.0f * (float)magispeller.getShakeAmount();
            var10000.f_104201_ += (-0.5f + this.random.nextFloat()) / 20.0f * (float)magispeller.getShakeAmount();
            var10000.f_104202_ += (-0.5f + this.random.nextFloat()) / 20.0f * (float)magispeller.getShakeAmount();
            right_arm.f_104203_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            right_arm.f_104204_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            right_arm.f_104205_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            left_arm.f_104203_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            left_arm.f_104204_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            left_arm.f_104205_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            var10000 = this.body.m_171324_("head");
            var10000.f_104203_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            var10000 = this.body.m_171324_("head");
            var10000.f_104204_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            var10000 = this.body.m_171324_("head");
            var10000.f_104205_ += (-0.5f + this.random.nextFloat()) / 2.0f * (float)magispeller.getShakeAmount() * ((float)Math.PI / 180);
            if (magispeller.isFaking()) {
                AnimationUtils.m_102091_((ModelPart)this.body.m_171324_("right_arm"), (ModelPart)this.body.m_171324_("left_arm"), (Mob)magispeller, (float)this.f_102608_, (float)ageInTicks);
            }
            if (magispeller.getArrowState() == 1) {
                this.body.m_171324_((String)"right_arm").f_104205_ = 1.5708f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -1.5708f;
            }
            if (magispeller.getArrowState() == 2) {
                AnimationUtils.m_102097_((ModelPart)this.body.m_171324_("left_arm"), (ModelPart)this.body.m_171324_("right_arm"), (ModelPart)this.body.m_171324_("head"), (boolean)true);
            }
            if (magispeller.isWavingArms()) {
                this.body.m_171324_((String)"right_arm").f_104202_ = 0.0f;
                this.body.m_171324_((String)"right_arm").f_104200_ = -5.0f;
                this.body.m_171324_((String)"left_arm").f_104202_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104200_ = 5.0f;
                this.body.m_171324_((String)"right_arm").f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.body.m_171324_((String)"left_arm").f_104203_ = Mth.m_14089_((float)(ageInTicks * 0.6662f)) * 0.25f;
                this.body.m_171324_((String)"right_arm").f_104205_ = 2.3561945f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -2.3561945f;
                this.body.m_171324_((String)"right_arm").f_104204_ = 0.0f;
                this.body.m_171324_((String)"left_arm").f_104204_ = 0.0f;
            }
            if (magispeller.isBalloon()) {
                this.body.m_171324_((String)"right_arm").f_104201_ = -9.0f;
                this.body.m_171324_((String)"left_arm").f_104201_ = -9.0f;
                this.body.m_171324_((String)"right_arm").f_104203_ = 3.1416f;
                this.body.m_171324_((String)"left_arm").f_104203_ = 3.1416f;
                this.body.m_171324_((String)"right_arm").f_104205_ = 0.4363f;
                this.body.m_171324_((String)"left_arm").f_104205_ = -0.4363f;
                this.right_leg.f_104202_ = -4.0f;
                this.right_leg.f_104201_ = 8.0f;
            }
        }
        var10000 = this.body.m_171324_("head");
        var10000.f_104204_ += netHeadYaw * ((float)Math.PI / 180);
        var10000 = this.body.m_171324_("head");
        var10000.f_104203_ += headPitch * ((float)Math.PI / 180);
        if (this.f_102609_) {
            this.left_leg.f_104203_ = -1.4137167f;
            this.left_leg.f_104204_ = -0.31415927f;
            this.left_leg.f_104205_ = -0.07853982f;
            this.right_leg.f_104203_ = -1.4137167f;
            this.right_leg.f_104204_ = 0.31415927f;
            this.right_leg.f_104205_ = 0.07853982f;
        } else {
            var10000 = this.right_leg;
            var10000.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
            var10000 = this.left_leg;
            var10000.f_104203_ += Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.left_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.right_leg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6002_(HumanoidArm p_102108_, PoseStack p_102109_) {
        this.m_142109_().m_104299_(p_102109_);
        this.body.m_104299_(p_102109_);
        this.getArm(p_102108_).m_104299_(p_102109_);
    }

    private ModelPart getArm(HumanoidArm p_191216_1_) {
        return p_191216_1_ == HumanoidArm.LEFT ? this.body.m_171324_("left_arm") : this.body.m_171324_("right_arm");
    }

    @Override
    public void translateToHead(PoseStack stack) {
        this.m_142109_().m_104299_(stack);
        this.body.m_104299_(stack);
        this.body.m_171324_("head").m_104299_(stack);
    }
}

