/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.client.model.CustomHeadedModel;
import com.yellowbrossproductions.illageandspillage.client.model.animation.EngineerAnimation;
import com.yellowbrossproductions.illageandspillage.entities.EngineerEntity;
import java.util.Calendar;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class EngineerModel<T extends Entity>
extends HierarchicalModel<T>
implements CustomHeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "engineer"), "main");
    private final ModelPart root;
    private final ModelPart all;
    private final ModelPart body;
    private final ModelPart left_arm;
    private final ModelPart right_arm;
    private final ModelPart left_leg;
    private final ModelPart right_leg;
    private final ModelPart head;

    public EngineerModel(ModelPart root) {
        this.root = root;
        this.all = this.root.m_171324_("all");
        this.body = this.all.m_171324_("body");
        this.left_arm = this.body.m_171324_("left_arm");
        this.right_arm = this.body.m_171324_("right_arm");
        this.left_leg = this.all.m_171324_("left_leg");
        this.right_leg = this.all.m_171324_("right_leg");
        this.head = this.body.m_171324_("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition all = partdefinition.m_171599_("all", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition body = all.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        body.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171480_().m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_arm = body.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(16, 36).m_171488_(-2.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-6.0f, (float)-10.0f, (float)0.0f));
        right_arm.m_171599_("hammer", CubeListBuilder.m_171558_().m_171514_(0, 52).m_171488_(-1.0f, -10.0f, -1.0f, 2.0f, 14.0f, 2.0f, new CubeDeformation(0.0f)).m_171514_(8, 52).m_171488_(-2.0f, -9.0f, -4.0f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)8.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-1.0f, -3.0f, -6.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.25f)).m_171514_(64, 0).m_171488_(-5.0f, -7.0f, -5.0f, 10.0f, 1.0f, 10.0f, new CubeDeformation(0.0f)).m_171514_(28, 18).m_171488_(-1.0f, -11.0f, -5.0f, 2.0f, 4.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition birthday = hat.m_171599_("birthday", CubeListBuilder.m_171558_().m_171514_(45, 46).m_171488_(-2.0f, -9.3333f, 6.0833f, 4.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(33, 46).m_171488_(-1.5f, -12.3333f, 6.5833f, 3.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(58, 43).m_171488_(0.0f, -15.3333f, 6.5833f, 0.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.6667f, (float)-8.0833f, (float)0.0f, (float)0.0f, (float)0.0873f));
        birthday.m_171599_("thingy", CubeListBuilder.m_171558_().m_171514_(58, 46).m_171488_(-1.5f, -15.3333f, 8.0f, 3.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        all.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.0f, (float)-12.0f, (float)0.0f));
        all.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-2.0f, (float)-12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        if (entity instanceof EngineerEntity) {
            EngineerEntity engineer = (EngineerEntity)entity;
            this.m_233385_(engineer.getAnimationState("throw"), EngineerAnimation.THROW, ageInTicks, engineer.getAnimationSpeed());
            this.m_233385_(engineer.getAnimationState("repair"), EngineerAnimation.REPAIR, ageInTicks, engineer.getAnimationSpeed());
            Calendar calendar = Calendar.getInstance();
            this.body.m_171324_((String)"head").m_171324_((String)"hat").m_171324_((String)"birthday").f_104207_ = calendar.get(2) == 1 && calendar.get(5) < 8;
            this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
            if (this.f_102609_) {
                if (engineer.getAnimationState() == 0) {
                    this.right_arm.f_104203_ = -0.62831855f;
                    this.left_arm.f_104203_ = -0.62831855f;
                    this.right_arm.f_104204_ = 0.0f;
                    this.right_arm.f_104205_ = 0.0f;
                    this.left_arm.f_104204_ = 0.0f;
                    this.left_arm.f_104205_ = 0.0f;
                }
                this.right_leg.f_104203_ = -1.4137167f;
                this.right_leg.f_104204_ = 0.31415927f;
                this.right_leg.f_104205_ = 0.07853982f;
                this.left_leg.f_104203_ = -1.4137167f;
                this.left_leg.f_104204_ = -0.31415927f;
                this.left_leg.f_104205_ = -0.07853982f;
            } else {
                if (engineer.getAnimationState() == 0) {
                    this.right_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
                    this.left_arm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
                    this.right_arm.f_104204_ = 0.0f;
                    this.right_arm.f_104205_ = 0.0f;
                    this.left_arm.f_104204_ = 0.0f;
                    this.left_arm.f_104205_ = 0.0f;
                }
                this.right_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
                this.right_leg.f_104204_ = 0.0f;
                this.right_leg.f_104205_ = 0.0f;
                this.left_leg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
                this.left_leg.f_104204_ = 0.0f;
                this.left_leg.f_104205_ = 0.0f;
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.all.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void translateToHead(PoseStack stack) {
        this.m_142109_().m_104299_(stack);
        this.all.m_104299_(stack);
        this.body.m_104299_(stack);
        this.head.m_104299_(stack);
    }
}

