/*
 * Decompiled with CFR 0.152.
 */
package com.yellowbrossproductions.illageandspillage.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yellowbrossproductions.illageandspillage.entities.CrashagerEntity;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class CrashagerModel<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("illageandspillage", "crashager"), "main");
    private final ModelPart body;

    public CrashagerModel(ModelPart root) {
        this.body = root.m_171324_("body");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)1.0f, (float)3.5f));
        body.m_171599_("rotation", CubeListBuilder.m_171558_().m_171514_(0, 55).m_171488_(-7.0f, -10.0f, -7.0f, 14.0f, 16.0f, 20.0f, new CubeDeformation(0.0f)).m_171514_(0, 91).m_171488_(-6.0f, 6.0f, -7.0f, 12.0f, 13.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(68, 73).m_171488_(-5.0f, -1.0f, -18.0f, 10.0f, 10.0f, 18.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-7.0f, (float)4.5f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-8.0f, -20.0f, -14.0f, 16.0f, 20.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-2.0f, -6.0f, -18.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)16.0f, (float)-18.0f));
        PartDefinition horns = head.m_171599_("horns", CubeListBuilder.m_171558_().m_171514_(74, 55).m_171488_(-5.0f, -14.0f, -1.0f, 2.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.0f, (float)-13.0f, (float)-9.0f, (float)1.0472f, (float)0.0f, (float)0.0f));
        horns.m_171599_("left_horn", CubeListBuilder.m_171558_().m_171514_(74, 55).m_171480_().m_171488_(8.0f, -41.0f, -20.0f, 2.0f, 14.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)27.0f, (float)19.0f));
        head.m_171599_("jaw", CubeListBuilder.m_171558_().m_171514_(0, 36).m_171488_(-8.0f, 0.0f, -16.0f, 16.0f, 3.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)2.0f));
        body.m_171599_("leg1", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171488_(-20.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-14.0f, (float)17.5f));
        body.m_171599_("leg2", CubeListBuilder.m_171558_().m_171514_(96, 0).m_171480_().m_171488_(12.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-14.0f, (float)17.5f));
        body.m_171599_("leg3", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-20.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)8.0f, (float)-14.0f, (float)-7.0f));
        body.m_171599_("leg4", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171480_().m_171488_(12.0f, 0.0f, -4.0f, 8.0f, 37.0f, 8.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-8.0f, (float)-14.0f, (float)-7.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void m_6973_(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity instanceof CrashagerEntity) {
            if (((CrashagerEntity)entity).getAttackStage() == 1) {
                this.resetAngles(limbSwing, limbSwingAmount, netHeadYaw, headPitch);
                this.body.f_104203_ = 0.2618f;
                this.body.m_171324_((String)"neck").m_171324_((String)"head").f_104203_ = headPitch * ((float)Math.PI / 180) - 0.2618f;
                this.body.m_171324_((String)"leg1").f_104201_ = -8.0f;
                this.body.m_171324_((String)"leg2").f_104201_ = -8.0f;
                this.body.m_171324_((String)"leg1").f_104203_ = 0.0f;
                this.body.m_171324_((String)"leg2").f_104203_ = 0.0f;
                this.body.m_171324_((String)"leg3").f_104203_ = -0.4363f;
                this.body.m_171324_((String)"leg4").f_104203_ = -0.4363f;
            }
            if (((CrashagerEntity)entity).getAttackStage() == 2) {
                this.resetAngles(limbSwing, limbSwingAmount, netHeadYaw, headPitch);
                this.body.f_104203_ = 0.2618f;
                this.body.f_104202_ = -2.5f;
                this.body.m_171324_((String)"neck").f_104202_ = -5.5f;
                this.body.m_171324_((String)"neck").f_104203_ = -0.3491f;
                this.body.m_171324_((String)"neck").m_171324_((String)"head").f_104203_ = -0.6981f;
                this.body.m_171324_((String)"neck").m_171324_((String)"head").m_171324_((String)"jaw").f_104203_ = 0.8727f;
                this.body.m_171324_((String)"leg1").f_104201_ = -8.0f;
                this.body.m_171324_((String)"leg2").f_104201_ = -8.0f;
                this.body.m_171324_((String)"leg1").f_104203_ = 0.0873f;
                this.body.m_171324_((String)"leg2").f_104203_ = 0.0873f;
                this.body.m_171324_((String)"leg3").f_104203_ = -0.1745f;
                this.body.m_171324_((String)"leg4").f_104203_ = -0.1745f;
            } else {
                this.resetAngles(limbSwing, limbSwingAmount, netHeadYaw, headPitch);
            }
        }
    }

    public void resetAngles(float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch) {
        this.body.m_171324_((String)"neck").m_171324_((String)"head").f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.m_171324_((String)"neck").m_171324_((String)"head").f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104203_ = 0.0f;
        this.body.m_171324_((String)"leg1").f_104201_ = -14.0f;
        this.body.m_171324_((String)"leg2").f_104201_ = -14.0f;
        this.body.m_171324_((String)"leg1").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.body.m_171324_((String)"leg2").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.body.m_171324_((String)"leg3").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount * 0.5f;
        this.body.m_171324_((String)"leg4").f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount * 0.5f;
        this.body.m_171324_((String)"neck").f_104202_ = 4.5f;
        this.body.f_104202_ = 3.5f;
        this.body.m_171324_((String)"neck").f_104203_ = 0.0f;
        this.body.m_171324_((String)"neck").m_171324_((String)"head").m_171324_((String)"jaw").f_104203_ = 0.0f;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }
}

