/*
 * Decompiled with CFR 0.152.
 */
package dev.shwg.smoothswapping.config;

import dev.shwg.smoothswapping.SmoothSwapping;
import dev.shwg.smoothswapping.SwapUtil;
import dev.shwg.smoothswapping.mixin.SimpleInventoryAccessor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class InventoryWidget
extends AbstractWidget {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/container/generic_54.png");
    private static final int textureWidth = 176;
    private static final int textureHeight = 222;
    private static final int borderWidth = 7;
    private static final int slotHeight = 18;
    private static final int borderWidthTop = 17;
    private static final int splitterHeight = 14;
    private final int columns;
    private final int rows;
    public final NonNullList<Slot> slots = NonNullList.m_122779_();
    private final Component title;
    private Slot focusedSlot;
    private ItemStack mouseStack;
    SimpleContainer inventory;

    public InventoryWidget(int x, int y, int columns, int rows, Component title) {
        super(x, y, columns * 18 + 14, rows * 18 + 17 + 7 + 14, CommonComponents.f_237098_);
        this.title = title;
        this.columns = columns;
        this.rows = rows;
        this.inventory = new SimpleContainer(columns * rows);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                Slot slot = new Slot((Container)this.inventory, this.slots.size(), x + 1 + 7 + column * 18, y + 1 + 17 + row * 18 + (row == rows - 1 ? 14 : 0));
                slot.m_269060_(ItemStack.f_41583_);
                this.slots.add((Object)slot);
            }
        }
        this.inventory.m_6836_(0, new ItemStack((ItemLike)Items.f_42594_, 32));
        this.mouseStack = ItemStack.f_41583_;
    }

    public void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        context.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_(), 0, 0, 7, this.f_93619_ - 7);
        context.m_280218_(TEXTURE, this.m_252754_(), this.m_252907_() + this.f_93619_ - 7, 0, 215, 7, 7);
        context.m_280218_(TEXTURE, this.m_252754_() + 7, this.m_252907_(), 7, 0, this.f_93618_ - 14, 17);
        context.m_280218_(TEXTURE, this.m_252754_() + this.f_93618_ - 7, this.m_252907_(), 169, 0, 7, this.f_93619_ - 7);
        context.m_280218_(TEXTURE, this.m_252754_() + this.f_93618_ - 7, this.m_252907_() + this.f_93619_ - 7, 169, 215, 7, 7);
        context.m_280218_(TEXTURE, this.m_252754_() + 7, this.m_252907_() + this.f_93619_ - 7, 7, 215, this.f_93618_ - 14, 7);
        context.m_280218_(TEXTURE, this.m_252754_() + 7, this.m_252907_() + 17 + (this.rows - 1) * 18, 7, 125, this.f_93618_ - 14, 14);
        for (int row = 0; row < this.rows; ++row) {
            for (int column = 0; column < this.columns; ++column) {
                context.m_280218_(TEXTURE, this.m_252754_() + 7 + column * 18, this.m_252907_() + 17 + row * 18 + (row == this.rows - 1 ? 14 : 0), 7, 17, 18, 18);
            }
        }
        Font textRenderer = Minecraft.m_91087_().f_91062_;
        int maxNameWidth = this.f_93618_ - 14 - 2;
        Component trimmedName = this.title;
        if (textRenderer.m_92852_((FormattedText)this.title) > maxNameWidth) {
            trimmedName = FormattedText.m_130773_((FormattedText[])new FormattedText[]{textRenderer.m_92854_((FormattedText)this.title, maxNameWidth - textRenderer.m_92852_((FormattedText)CommonComponents.f_238772_)), CommonComponents.f_238772_});
        }
        context.m_280056_(textRenderer, trimmedName.getString(), this.m_252754_() + 8, this.m_252907_() + 6, 0x404040, false);
        for (Slot slot : this.slots) {
            if (slot.m_6659_()) {
                this.drawSlot(context, slot);
            }
            if (!this.isPointOverSlot(slot, mouseX, mouseY) || !slot.m_6659_()) continue;
            this.focusedSlot = slot;
            AbstractContainerScreen.m_280359_((GuiGraphics)context, (int)slot.f_40220_, (int)slot.f_40221_, (int)this.m_267579_());
        }
        if (!this.mouseStack.m_41619_()) {
            int x = mouseX - 8;
            int y = mouseY - 8;
            context.m_280480_(this.mouseStack, x, y);
            context.m_280370_(Minecraft.m_91087_().f_91062_, this.mouseStack, x, y);
        }
    }

    private boolean isPointOverSlot(Slot slot, double mouseX, double mouseY) {
        if (slot == null) {
            return false;
        }
        int x = slot.f_40220_;
        int y = slot.f_40221_;
        return mouseX >= (double)x && mouseX < (double)(x + 18) && mouseY >= (double)y && mouseY < (double)(y + 18);
    }

    private void drawSlot(GuiGraphics context, Slot slot) {
        ItemStack itemStack = slot.m_7993_();
        context.m_280480_(itemStack, slot.f_40220_, slot.f_40221_);
        context.m_280370_(Minecraft.m_91087_().f_91062_, itemStack, slot.f_40220_, slot.f_40221_);
    }

    protected void m_168797_(NarrationElementOutput builder) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.isPointOverSlot(this.focusedSlot, mouseX, mouseY)) {
            if (Screen.m_96638_()) {
                if (this.focusedSlot.m_150661_() >= this.slots.size() - this.columns) {
                    for (int i = 0; i < this.slots.size() - this.columns; ++i) {
                        if (!this.moveItems(i)) continue;
                        return true;
                    }
                } else {
                    for (int i = this.slots.size() - 1; i >= this.slots.size() - this.columns; --i) {
                        if (!this.moveItems(i)) continue;
                        return true;
                    }
                }
            } else {
                if (this.mouseStack.m_41619_() && !this.focusedSlot.m_7993_().m_41619_()) {
                    this.mouseStack = this.focusedSlot.m_7993_().m_41777_();
                    this.focusedSlot.m_269060_(ItemStack.f_41583_);
                    return true;
                }
                if (!this.mouseStack.m_41619_() && this.focusedSlot.m_7993_().m_41619_()) {
                    this.focusedSlot.m_269060_(this.mouseStack.m_41777_());
                    this.mouseStack = ItemStack.f_41583_;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean moveItems(int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot.m_7993_().m_41619_()) {
            SmoothSwapping.currentStacks = ((SimpleInventoryAccessor)this.inventory).getStacks();
            SwapUtil.copyStacks(SmoothSwapping.currentStacks, SmoothSwapping.oldStacks);
            slot.m_269060_(this.focusedSlot.m_7993_());
            this.focusedSlot.m_269060_(ItemStack.f_41583_);
            SwapUtil.addI2IInventorySwap(slot.m_150661_(), this.focusedSlot, slot, false, slot.m_7993_().m_41613_());
            return true;
        }
        return false;
    }
}

